@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin

import com.pulumi.azurenative.azuredatatransfer.AzuredatatransferFunctions.getConnectionPlain
import com.pulumi.azurenative.azuredatatransfer.AzuredatatransferFunctions.getFlowPlain
import com.pulumi.azurenative.azuredatatransfer.AzuredatatransferFunctions.getPipelinePlain
import com.pulumi.azurenative.azuredatatransfer.AzuredatatransferFunctions.listAzureDataTransferApprovedSchemasPlain
import com.pulumi.azurenative.azuredatatransfer.AzuredatatransferFunctions.listListPendingConnectionPlain
import com.pulumi.azurenative.azuredatatransfer.AzuredatatransferFunctions.listListPendingFlowPlain
import com.pulumi.azurenative.azuredatatransfer.AzuredatatransferFunctions.listListSchemaPlain
import com.pulumi.azurenative.azuredatatransfer.kotlin.enums.ListApprovedSchemasDirection
import com.pulumi.azurenative.azuredatatransfer.kotlin.enums.SchemaStatus
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.GetConnectionPlainArgs
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.GetConnectionPlainArgsBuilder
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.GetFlowPlainArgs
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.GetFlowPlainArgsBuilder
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.GetPipelinePlainArgs
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.GetPipelinePlainArgsBuilder
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.ListAzureDataTransferApprovedSchemasPlainArgs
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.ListAzureDataTransferApprovedSchemasPlainArgsBuilder
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.ListListPendingConnectionPlainArgs
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.ListListPendingConnectionPlainArgsBuilder
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.ListListPendingFlowPlainArgs
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.ListListPendingFlowPlainArgsBuilder
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.ListListSchemaPlainArgs
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.ListListSchemaPlainArgsBuilder
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.GetConnectionResult
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.GetFlowResult
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.GetPipelineResult
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ListAzureDataTransferApprovedSchemasResult
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ListListPendingConnectionResult
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ListListPendingFlowResult
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ListListSchemaResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.GetConnectionResult.Companion.toKotlin as getConnectionResultToKotlin
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.GetFlowResult.Companion.toKotlin as getFlowResultToKotlin
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.GetPipelineResult.Companion.toKotlin as getPipelineResultToKotlin
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ListAzureDataTransferApprovedSchemasResult.Companion.toKotlin as listAzureDataTransferApprovedSchemasResultToKotlin
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ListListPendingConnectionResult.Companion.toKotlin as listListPendingConnectionResultToKotlin
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ListListPendingFlowResult.Companion.toKotlin as listListPendingFlowResultToKotlin
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ListListSchemaResult.Companion.toKotlin as listListSchemaResultToKotlin

public object AzuredatatransferFunctions {
    /**
     * Gets connection resource.
     * Azure REST API version: 2023-10-11-preview.
     * Other available API versions: 2024-01-25.
     * @param argument null
     * @return The connection resource definition.
     */
    public suspend fun getConnection(argument: GetConnectionPlainArgs): GetConnectionResult =
        getConnectionResultToKotlin(getConnectionPlain(argument.toJava()).await())

    /**
     * @see [getConnection].
     * @param connectionName The name for the connection that is to be requested.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The connection resource definition.
     */
    public suspend fun getConnection(connectionName: String, resourceGroupName: String):
        GetConnectionResult {
        val argument = GetConnectionPlainArgs(
            connectionName = connectionName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectionResultToKotlin(getConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azuredatatransfer&#46;kotlin&#46;inputs&#46;GetConnectionPlainArgs].
     * @return The connection resource definition.
     */
    public suspend fun getConnection(argument: suspend GetConnectionPlainArgsBuilder.() -> Unit):
        GetConnectionResult {
        val builder = GetConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectionResultToKotlin(getConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets flow resource.
     * Azure REST API version: 2023-10-11-preview.
     * Other available API versions: 2024-01-25.
     * @param argument null
     * @return The flow resource definition.
     */
    public suspend fun getFlow(argument: GetFlowPlainArgs): GetFlowResult =
        getFlowResultToKotlin(getFlowPlain(argument.toJava()).await())

    /**
     * @see [getFlow].
     * @param connectionName The name for the connection that is to be requested.
     * @param flowName The name for the flow that is to be onboarded.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The flow resource definition.
     */
    public suspend fun getFlow(
        connectionName: String,
        flowName: String,
        resourceGroupName: String,
    ): GetFlowResult {
        val argument = GetFlowPlainArgs(
            connectionName = connectionName,
            flowName = flowName,
            resourceGroupName = resourceGroupName,
        )
        return getFlowResultToKotlin(getFlowPlain(argument.toJava()).await())
    }

    /**
     * @see [getFlow].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azuredatatransfer&#46;kotlin&#46;inputs&#46;GetFlowPlainArgs].
     * @return The flow resource definition.
     */
    public suspend fun getFlow(argument: suspend GetFlowPlainArgsBuilder.() -> Unit): GetFlowResult {
        val builder = GetFlowPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFlowResultToKotlin(getFlowPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets pipeline resource.
     * Azure REST API version: 2023-10-11-preview.
     * Other available API versions: 2024-01-25.
     * @param argument null
     * @return The pipeline resource definition.
     */
    public suspend fun getPipeline(argument: GetPipelinePlainArgs): GetPipelineResult =
        getPipelineResultToKotlin(getPipelinePlain(argument.toJava()).await())

    /**
     * @see [getPipeline].
     * @param pipelineName The name for the pipeline that is to be requested.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The pipeline resource definition.
     */
    public suspend fun getPipeline(pipelineName: String, resourceGroupName: String):
        GetPipelineResult {
        val argument = GetPipelinePlainArgs(
            pipelineName = pipelineName,
            resourceGroupName = resourceGroupName,
        )
        return getPipelineResultToKotlin(getPipelinePlain(argument.toJava()).await())
    }

    /**
     * @see [getPipeline].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azuredatatransfer&#46;kotlin&#46;inputs&#46;GetPipelinePlainArgs].
     * @return The pipeline resource definition.
     */
    public suspend fun getPipeline(argument: suspend GetPipelinePlainArgsBuilder.() -> Unit):
        GetPipelineResult {
        val builder = GetPipelinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPipelineResultToKotlin(getPipelinePlain(builtArgument.toJava()).await())
    }

    /**
     * Lists approved schemas for Azure Data Transfer.
     * Azure REST API version: 2023-10-11-preview.
     * Other available API versions: 2024-01-25.
     * @param argument null
     * @return The schemas list result.
     */
    public suspend
    fun listAzureDataTransferApprovedSchemas(argument: ListAzureDataTransferApprovedSchemasPlainArgs):
        ListAzureDataTransferApprovedSchemasResult =
        listAzureDataTransferApprovedSchemasResultToKotlin(listAzureDataTransferApprovedSchemasPlain(argument.toJava()).await())

    /**
     * @see [listAzureDataTransferApprovedSchemas].
     * @param direction The direction pipeline to filter approved schemas.
     * @param pipeline The name of the pipeline to filter approved schemas.
     * @return The schemas list result.
     */
    public suspend
    fun listAzureDataTransferApprovedSchemas(
        direction: Either<String, ListApprovedSchemasDirection>? =
            null,
        pipeline: String? = null,
    ): ListAzureDataTransferApprovedSchemasResult {
        val argument = ListAzureDataTransferApprovedSchemasPlainArgs(
            direction = direction,
            pipeline = pipeline,
        )
        return listAzureDataTransferApprovedSchemasResultToKotlin(listAzureDataTransferApprovedSchemasPlain(argument.toJava()).await())
    }

    /**
     * @see [listAzureDataTransferApprovedSchemas].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azuredatatransfer&#46;kotlin&#46;inputs&#46;ListAzureDataTransferApprovedSchemasPlainArgs].
     * @return The schemas list result.
     */
    public suspend
    fun listAzureDataTransferApprovedSchemas(argument: suspend ListAzureDataTransferApprovedSchemasPlainArgsBuilder.() -> Unit):
        ListAzureDataTransferApprovedSchemasResult {
        val builder = ListAzureDataTransferApprovedSchemasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAzureDataTransferApprovedSchemasResultToKotlin(listAzureDataTransferApprovedSchemasPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists all pending connections for a connection.
     * Azure REST API version: 2023-10-11-preview.
     * Other available API versions: 2024-01-25.
     * @param argument null
     * @return The connections list result.
     */
    public suspend fun listListPendingConnection(argument: ListListPendingConnectionPlainArgs):
        ListListPendingConnectionResult =
        listListPendingConnectionResultToKotlin(listListPendingConnectionPlain(argument.toJava()).await())

    /**
     * @see [listListPendingConnection].
     * @param connectionName The name for the connection that is to be requested.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The connections list result.
     */
    public suspend fun listListPendingConnection(connectionName: String, resourceGroupName: String):
        ListListPendingConnectionResult {
        val argument = ListListPendingConnectionPlainArgs(
            connectionName = connectionName,
            resourceGroupName = resourceGroupName,
        )
        return listListPendingConnectionResultToKotlin(listListPendingConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [listListPendingConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azuredatatransfer&#46;kotlin&#46;inputs&#46;ListListPendingConnectionPlainArgs].
     * @return The connections list result.
     */
    public suspend
    fun listListPendingConnection(argument: suspend ListListPendingConnectionPlainArgsBuilder.() -> Unit):
        ListListPendingConnectionResult {
        val builder = ListListPendingConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listListPendingConnectionResultToKotlin(listListPendingConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists all pending flows for a connection.
     * Azure REST API version: 2023-10-11-preview.
     * Other available API versions: 2024-01-25.
     * @param argument null
     * @return The connections list result.
     */
    public suspend fun listListPendingFlow(argument: ListListPendingFlowPlainArgs):
        ListListPendingFlowResult =
        listListPendingFlowResultToKotlin(listListPendingFlowPlain(argument.toJava()).await())

    /**
     * @see [listListPendingFlow].
     * @param connectionName The name for the connection that is to be requested.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The connections list result.
     */
    public suspend fun listListPendingFlow(connectionName: String, resourceGroupName: String):
        ListListPendingFlowResult {
        val argument = ListListPendingFlowPlainArgs(
            connectionName = connectionName,
            resourceGroupName = resourceGroupName,
        )
        return listListPendingFlowResultToKotlin(listListPendingFlowPlain(argument.toJava()).await())
    }

    /**
     * @see [listListPendingFlow].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azuredatatransfer&#46;kotlin&#46;inputs&#46;ListListPendingFlowPlainArgs].
     * @return The connections list result.
     */
    public suspend
    fun listListPendingFlow(argument: suspend ListListPendingFlowPlainArgsBuilder.() -> Unit):
        ListListPendingFlowResult {
        val builder = ListListPendingFlowPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listListPendingFlowResultToKotlin(listListPendingFlowPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the schemas for the specified connection in a pipeline.
     * Azure REST API version: 2023-10-11-preview.
     * Other available API versions: 2024-01-25.
     * @param argument null
     * @return The schemas list result.
     */
    public suspend fun listListSchema(argument: ListListSchemaPlainArgs): ListListSchemaResult =
        listListSchemaResultToKotlin(listListSchemaPlain(argument.toJava()).await())

    /**
     * @see [listListSchema].
     * @param connectionId Connection ID associated with this schema
     * @param content Content of the schema
     * @param id ID associated with this schema
     * @param name Name of the schema
     * @param pipelineName The name for the pipeline that is to be requested.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param status Status of the schema
     * @return The schemas list result.
     */
    public suspend fun listListSchema(
        connectionId: String? = null,
        content: String? = null,
        id: String? = null,
        name: String? = null,
        pipelineName: String,
        resourceGroupName: String,
        status: Either<String, SchemaStatus>? = null,
    ): ListListSchemaResult {
        val argument = ListListSchemaPlainArgs(
            connectionId = connectionId,
            content = content,
            id = id,
            name = name,
            pipelineName = pipelineName,
            resourceGroupName = resourceGroupName,
            status = status,
        )
        return listListSchemaResultToKotlin(listListSchemaPlain(argument.toJava()).await())
    }

    /**
     * @see [listListSchema].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azuredatatransfer&#46;kotlin&#46;inputs&#46;ListListSchemaPlainArgs].
     * @return The schemas list result.
     */
    public suspend fun listListSchema(argument: suspend ListListSchemaPlainArgsBuilder.() -> Unit):
        ListListSchemaResult {
        val builder = ListListSchemaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listListSchemaResultToKotlin(listListSchemaPlain(builtArgument.toJava()).await())
    }
}
