@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin

import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ConnectionPropertiesResponse
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ConnectionPropertiesResponse.Companion.toKotlin as connectionPropertiesResponseToKotlin
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Connection].
 */
@PulumiTagMarker
public class ConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionArgs = ConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionArgsBuilder.() -> Unit) {
        val builder = ConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Connection {
        val builtJavaResource =
            com.pulumi.azurenative.azuredatatransfer.Connection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Connection(builtJavaResource)
    }
}

/**
 * The connection resource definition.
 * Azure REST API version: 2023-10-11-preview.
 * Other available API versions: 2024-01-25.
 * ## Example Usage
 * ### Creates or updates the connection resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connection = new AzureNative.AzureDataTransfer.Connection("connection", new()
 *     {
 *         ConnectionName = "testConnection",
 *         Location = "East US",
 *         Properties = new AzureNative.AzureDataTransfer.Inputs.ConnectionPropertiesArgs
 *         {
 *             Justification = "justification",
 *             Pipeline = "testdc",
 *             RequirementId = "id",
 *         },
 *         ResourceGroupName = "testRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuredatatransfer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuredatatransfer.NewConnection(ctx, "connection", &azuredatatransfer.ConnectionArgs{
 * 			ConnectionName: pulumi.String("testConnection"),
 * 			Location:       pulumi.String("East US"),
 * 			Properties: &azuredatatransfer.ConnectionPropertiesArgs{
 * 				Justification: pulumi.String("justification"),
 * 				Pipeline:      pulumi.String("testdc"),
 * 				RequirementId: pulumi.String("id"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuredatatransfer.Connection;
 * import com.pulumi.azurenative.azuredatatransfer.ConnectionArgs;
 * import com.pulumi.azurenative.azuredatatransfer.inputs.ConnectionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connection = new Connection("connection", ConnectionArgs.builder()
 *             .connectionName("testConnection")
 *             .location("East US")
 *             .properties(ConnectionPropertiesArgs.builder()
 *                 .justification("justification")
 *                 .pipeline("testdc")
 *                 .requirementId("id")
 *                 .build())
 *             .resourceGroupName("testRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuredatatransfer:Connection myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureDataTransfer/connections/{connectionName}
 * ```
 */
public class Connection internal constructor(
    override val javaResource: com.pulumi.azurenative.azuredatatransfer.Connection,
) : KotlinCustomResource(javaResource, ConnectionMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of connection
     */
    public val properties: Output<ConnectionPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                connectionPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectionMapper : ResourceMapper<Connection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azuredatatransfer.Connection::class == javaResource::class

    override fun map(javaResource: Resource): Connection = Connection(
        javaResource as
            com.pulumi.azurenative.azuredatatransfer.Connection,
    )
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connection].
 */
public suspend fun connection(name: String, block: suspend ConnectionResourceBuilder.() -> Unit):
    Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connection(name: String): Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
