@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Flow type for the specified resource
 */
public enum class FlowType(
    public val javaValue: com.pulumi.azurenative.azuredatatransfer.enums.FlowType,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.enums.FlowType> {
    Unknown(com.pulumi.azurenative.azuredatatransfer.enums.FlowType.Unknown),
    Complex(com.pulumi.azurenative.azuredatatransfer.enums.FlowType.Complex),
    DevSecOps(com.pulumi.azurenative.azuredatatransfer.enums.FlowType.DevSecOps),
    Messaging(com.pulumi.azurenative.azuredatatransfer.enums.FlowType.Messaging),
    Mission(com.pulumi.azurenative.azuredatatransfer.enums.FlowType.Mission),
    MicrosoftInternal(com.pulumi.azurenative.azuredatatransfer.enums.FlowType.MicrosoftInternal),
    BasicFiles(com.pulumi.azurenative.azuredatatransfer.enums.FlowType.BasicFiles),
    Data(com.pulumi.azurenative.azuredatatransfer.enums.FlowType.Data),
    ;

    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.enums.FlowType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuredatatransfer.enums.FlowType): FlowType =
            FlowType.values().first { it.javaValue == javaType }
    }
}
