@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.inputs

import com.pulumi.azurenative.azuredatatransfer.inputs.ConnectionPropertiesArgs.builder
import com.pulumi.azurenative.azuredatatransfer.kotlin.enums.Direction
import com.pulumi.azurenative.azuredatatransfer.kotlin.enums.FlowType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of connection
 * @property direction Direction of data movement
 * @property flowTypes The flow types being requested for this connection
 * @property justification Justification for the connection request
 * @property pin PIN to link requests together
 * @property pipeline Pipeline to use to transfer data
 * @property policies The policies for this connection
 * @property primaryContact The primary contact for this connection request
 * @property remoteSubscriptionId Subscription ID to link cloud subscriptions together
 * @property requirementId Requirement ID of the connection
 * @property schemas The schemas for this connection
 * @property secondaryContacts The secondary contacts for this connection request
 */
public data class ConnectionPropertiesArgs(
    public val direction: Output<Either<String, Direction>>? = null,
    public val flowTypes: Output<List<Either<String, FlowType>>>? = null,
    public val justification: Output<String>? = null,
    public val pin: Output<String>? = null,
    public val pipeline: Output<String>,
    public val policies: Output<List<String>>? = null,
    public val primaryContact: Output<String>? = null,
    public val remoteSubscriptionId: Output<String>? = null,
    public val requirementId: Output<String>? = null,
    public val schemas: Output<List<SchemaArgs>>? = null,
    public val secondaryContacts: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.inputs.ConnectionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.inputs.ConnectionPropertiesArgs =
        com.pulumi.azurenative.azuredatatransfer.inputs.ConnectionPropertiesArgs.builder()
            .direction(
                direction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .flowTypes(
                flowTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .justification(justification?.applyValue({ args0 -> args0 }))
            .pin(pin?.applyValue({ args0 -> args0 }))
            .pipeline(pipeline.applyValue({ args0 -> args0 }))
            .policies(policies?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .primaryContact(primaryContact?.applyValue({ args0 -> args0 }))
            .remoteSubscriptionId(remoteSubscriptionId?.applyValue({ args0 -> args0 }))
            .requirementId(requirementId?.applyValue({ args0 -> args0 }))
            .schemas(
                schemas?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .secondaryContacts(secondaryContacts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class ConnectionPropertiesArgsBuilder internal constructor() {
    private var direction: Output<Either<String, Direction>>? = null

    private var flowTypes: Output<List<Either<String, FlowType>>>? = null

    private var justification: Output<String>? = null

    private var pin: Output<String>? = null

    private var pipeline: Output<String>? = null

    private var policies: Output<List<String>>? = null

    private var primaryContact: Output<String>? = null

    private var remoteSubscriptionId: Output<String>? = null

    private var requirementId: Output<String>? = null

    private var schemas: Output<List<SchemaArgs>>? = null

    private var secondaryContacts: Output<List<String>>? = null

    /**
     * @param value Direction of data movement
     */
    @JvmName("muddlblbsvisdkeq")
    public suspend fun direction(`value`: Output<Either<String, Direction>>) {
        this.direction = value
    }

    /**
     * @param value The flow types being requested for this connection
     */
    @JvmName("bvorgsstieiwcjca")
    public suspend fun flowTypes(`value`: Output<List<Either<String, FlowType>>>) {
        this.flowTypes = value
    }

    @JvmName("roauoqxesgqirlgn")
    public suspend fun flowTypes(vararg values: Output<Either<String, FlowType>>) {
        this.flowTypes = Output.all(values.asList())
    }

    /**
     * @param values The flow types being requested for this connection
     */
    @JvmName("nbiyssqopdpyscay")
    public suspend fun flowTypes(values: List<Output<Either<String, FlowType>>>) {
        this.flowTypes = Output.all(values)
    }

    /**
     * @param value Justification for the connection request
     */
    @JvmName("cexcyvvbffasgxgp")
    public suspend fun justification(`value`: Output<String>) {
        this.justification = value
    }

    /**
     * @param value PIN to link requests together
     */
    @JvmName("siichyfhntiglcjt")
    public suspend fun pin(`value`: Output<String>) {
        this.pin = value
    }

    /**
     * @param value Pipeline to use to transfer data
     */
    @JvmName("aysuovpvwyiaujhm")
    public suspend fun pipeline(`value`: Output<String>) {
        this.pipeline = value
    }

    /**
     * @param value The policies for this connection
     */
    @JvmName("tolmdubwihalefbr")
    public suspend fun policies(`value`: Output<List<String>>) {
        this.policies = value
    }

    @JvmName("vjtmitrnpfoagspq")
    public suspend fun policies(vararg values: Output<String>) {
        this.policies = Output.all(values.asList())
    }

    /**
     * @param values The policies for this connection
     */
    @JvmName("rayxymcejvfceudw")
    public suspend fun policies(values: List<Output<String>>) {
        this.policies = Output.all(values)
    }

    /**
     * @param value The primary contact for this connection request
     */
    @JvmName("oatfjogqklssexcg")
    public suspend fun primaryContact(`value`: Output<String>) {
        this.primaryContact = value
    }

    /**
     * @param value Subscription ID to link cloud subscriptions together
     */
    @JvmName("eympbenwbfvybvlt")
    public suspend fun remoteSubscriptionId(`value`: Output<String>) {
        this.remoteSubscriptionId = value
    }

    /**
     * @param value Requirement ID of the connection
     */
    @JvmName("chydbmpxklulsxhe")
    public suspend fun requirementId(`value`: Output<String>) {
        this.requirementId = value
    }

    /**
     * @param value The schemas for this connection
     */
    @JvmName("gsptefdvugcrmjnb")
    public suspend fun schemas(`value`: Output<List<SchemaArgs>>) {
        this.schemas = value
    }

    @JvmName("lsoeqqylqhtpsvue")
    public suspend fun schemas(vararg values: Output<SchemaArgs>) {
        this.schemas = Output.all(values.asList())
    }

    /**
     * @param values The schemas for this connection
     */
    @JvmName("dfusftplpjshsfjt")
    public suspend fun schemas(values: List<Output<SchemaArgs>>) {
        this.schemas = Output.all(values)
    }

    /**
     * @param value The secondary contacts for this connection request
     */
    @JvmName("rrsjnfuvmahkufxd")
    public suspend fun secondaryContacts(`value`: Output<List<String>>) {
        this.secondaryContacts = value
    }

    @JvmName("woptattqkvcyxflq")
    public suspend fun secondaryContacts(vararg values: Output<String>) {
        this.secondaryContacts = Output.all(values.asList())
    }

    /**
     * @param values The secondary contacts for this connection request
     */
    @JvmName("uwtsmrknnixbpagi")
    public suspend fun secondaryContacts(values: List<Output<String>>) {
        this.secondaryContacts = Output.all(values)
    }

    /**
     * @param value Direction of data movement
     */
    @JvmName("bsddgspcthpybpnk")
    public suspend fun direction(`value`: Either<String, Direction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction of data movement
     */
    @JvmName("xpjnaunooabahdme")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Direction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction of data movement
     */
    @JvmName("iyfbbljhphugrdxb")
    public fun direction(`value`: Direction) {
        val toBeMapped = Either.ofRight<String, Direction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The flow types being requested for this connection
     */
    @JvmName("jtukddolssjeipmm")
    public suspend fun flowTypes(`value`: List<Either<String, FlowType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowTypes = mapped
    }

    /**
     * @param values The flow types being requested for this connection
     */
    @JvmName("yptjtpokwmfhatkf")
    public suspend fun flowTypes(vararg values: Either<String, FlowType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flowTypes = mapped
    }

    /**
     * @param value Justification for the connection request
     */
    @JvmName("axoshbctgnwobtto")
    public suspend fun justification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.justification = mapped
    }

    /**
     * @param value PIN to link requests together
     */
    @JvmName("xgnrysigvvnemlwu")
    public suspend fun pin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pin = mapped
    }

    /**
     * @param value Pipeline to use to transfer data
     */
    @JvmName("lwleueexdlgsuldo")
    public suspend fun pipeline(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipeline = mapped
    }

    /**
     * @param value The policies for this connection
     */
    @JvmName("eyacpolescloanne")
    public suspend fun policies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param values The policies for this connection
     */
    @JvmName("dqnfmcylfptblxfj")
    public suspend fun policies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param value The primary contact for this connection request
     */
    @JvmName("veuxqwmrlqmcpaqi")
    public suspend fun primaryContact(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryContact = mapped
    }

    /**
     * @param value Subscription ID to link cloud subscriptions together
     */
    @JvmName("hrfhpdaltfgkfxiy")
    public suspend fun remoteSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteSubscriptionId = mapped
    }

    /**
     * @param value Requirement ID of the connection
     */
    @JvmName("ffanxcyqurbofbif")
    public suspend fun requirementId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requirementId = mapped
    }

    /**
     * @param value The schemas for this connection
     */
    @JvmName("gscgynnxmsbsthas")
    public suspend fun schemas(`value`: List<SchemaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemas = mapped
    }

    /**
     * @param argument The schemas for this connection
     */
    @JvmName("aqhlanmgrjlijffv")
    public suspend fun schemas(argument: List<suspend SchemaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SchemaArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.schemas = mapped
    }

    /**
     * @param argument The schemas for this connection
     */
    @JvmName("ajyqvmgcnxgnwlwe")
    public suspend fun schemas(vararg argument: suspend SchemaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SchemaArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.schemas = mapped
    }

    /**
     * @param argument The schemas for this connection
     */
    @JvmName("lldqkxvrgcmvuomn")
    public suspend fun schemas(argument: suspend SchemaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SchemaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.schemas = mapped
    }

    /**
     * @param values The schemas for this connection
     */
    @JvmName("huwmrhfdubxftspc")
    public suspend fun schemas(vararg values: SchemaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemas = mapped
    }

    /**
     * @param value The secondary contacts for this connection request
     */
    @JvmName("anrvlvtxqfjjxyvq")
    public suspend fun secondaryContacts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryContacts = mapped
    }

    /**
     * @param values The secondary contacts for this connection request
     */
    @JvmName("ypdfovvlsmuimesy")
    public suspend fun secondaryContacts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryContacts = mapped
    }

    internal fun build(): ConnectionPropertiesArgs = ConnectionPropertiesArgs(
        direction = direction,
        flowTypes = flowTypes,
        justification = justification,
        pin = pin,
        pipeline = pipeline ?: throw PulumiNullFieldException("pipeline"),
        policies = policies,
        primaryContact = primaryContact,
        remoteSubscriptionId = remoteSubscriptionId,
        requirementId = requirementId,
        schemas = schemas,
        secondaryContacts = secondaryContacts,
    )
}
