@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.inputs

import com.pulumi.azurenative.azuredatatransfer.inputs.FlowPropertiesArgs.builder
import com.pulumi.azurenative.azuredatatransfer.kotlin.enums.DataType
import com.pulumi.azurenative.azuredatatransfer.kotlin.enums.FlowStatus
import com.pulumi.azurenative.azuredatatransfer.kotlin.enums.FlowType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of flow
 * @property connection The connection associated with this flow
 * @property dataType Transfer Storage Blobs or Tables
 * @property flowType The flow type for this flow
 * @property keyVaultUri AME, PME, or TORUS only! AKV Chain Containing SAS Token
 * @property policies The policies for this flow
 * @property schema The selected schema for this flow
 * @property serviceBusQueueId Service Bus Queue ID
 * @property status Status of the current flow
 * @property storageAccountId Storage Account ID
 * @property storageAccountName Storage Account
 * @property storageContainerName Storage Container Name
 */
public data class FlowPropertiesArgs(
    public val connection: Output<SelectedResourceArgs>? = null,
    public val dataType: Output<Either<String, DataType>>? = null,
    public val flowType: Output<Either<String, FlowType>>? = null,
    public val keyVaultUri: Output<String>? = null,
    public val policies: Output<List<String>>? = null,
    public val schema: Output<SchemaArgs>? = null,
    public val serviceBusQueueId: Output<String>? = null,
    public val status: Output<Either<String, FlowStatus>>? = null,
    public val storageAccountId: Output<String>? = null,
    public val storageAccountName: Output<String>? = null,
    public val storageContainerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.inputs.FlowPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.inputs.FlowPropertiesArgs =
        com.pulumi.azurenative.azuredatatransfer.inputs.FlowPropertiesArgs.builder()
            .connection(connection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataType(
                dataType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .flowType(
                flowType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyVaultUri(keyVaultUri?.applyValue({ args0 -> args0 }))
            .policies(policies?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .schema(schema?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceBusQueueId(serviceBusQueueId?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 }))
            .storageContainerName(storageContainerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowPropertiesArgs].
 */
@PulumiTagMarker
public class FlowPropertiesArgsBuilder internal constructor() {
    private var connection: Output<SelectedResourceArgs>? = null

    private var dataType: Output<Either<String, DataType>>? = null

    private var flowType: Output<Either<String, FlowType>>? = null

    private var keyVaultUri: Output<String>? = null

    private var policies: Output<List<String>>? = null

    private var schema: Output<SchemaArgs>? = null

    private var serviceBusQueueId: Output<String>? = null

    private var status: Output<Either<String, FlowStatus>>? = null

    private var storageAccountId: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    private var storageContainerName: Output<String>? = null

    /**
     * @param value The connection associated with this flow
     */
    @JvmName("dtwivlwmhphwpift")
    public suspend fun connection(`value`: Output<SelectedResourceArgs>) {
        this.connection = value
    }

    /**
     * @param value Transfer Storage Blobs or Tables
     */
    @JvmName("bqmdldyavbdncpwr")
    public suspend fun dataType(`value`: Output<Either<String, DataType>>) {
        this.dataType = value
    }

    /**
     * @param value The flow type for this flow
     */
    @JvmName("tvunfegbxvujlglf")
    public suspend fun flowType(`value`: Output<Either<String, FlowType>>) {
        this.flowType = value
    }

    /**
     * @param value AME, PME, or TORUS only! AKV Chain Containing SAS Token
     */
    @JvmName("fgbymusexmscyicj")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The policies for this flow
     */
    @JvmName("tndejhsiqrmvpbun")
    public suspend fun policies(`value`: Output<List<String>>) {
        this.policies = value
    }

    @JvmName("surqgqlgpmtvqbjy")
    public suspend fun policies(vararg values: Output<String>) {
        this.policies = Output.all(values.asList())
    }

    /**
     * @param values The policies for this flow
     */
    @JvmName("jbtlsepjormvwkbo")
    public suspend fun policies(values: List<Output<String>>) {
        this.policies = Output.all(values)
    }

    /**
     * @param value The selected schema for this flow
     */
    @JvmName("rvoowrwjtqiirqiy")
    public suspend fun schema(`value`: Output<SchemaArgs>) {
        this.schema = value
    }

    /**
     * @param value Service Bus Queue ID
     */
    @JvmName("xpjfhvenrhhmfvcm")
    public suspend fun serviceBusQueueId(`value`: Output<String>) {
        this.serviceBusQueueId = value
    }

    /**
     * @param value Status of the current flow
     */
    @JvmName("wtxlsiwsgyumgeqf")
    public suspend fun status(`value`: Output<Either<String, FlowStatus>>) {
        this.status = value
    }

    /**
     * @param value Storage Account ID
     */
    @JvmName("nlpkdquterfwtkyf")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value Storage Account
     */
    @JvmName("jqcshdpexrrwqivl")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value Storage Container Name
     */
    @JvmName("tgeifsiaohvsqghl")
    public suspend fun storageContainerName(`value`: Output<String>) {
        this.storageContainerName = value
    }

    /**
     * @param value The connection associated with this flow
     */
    @JvmName("pjqpwhxjxdregysw")
    public suspend fun connection(`value`: SelectedResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connection = mapped
    }

    /**
     * @param argument The connection associated with this flow
     */
    @JvmName("cjhfmvgsoiopsnum")
    public suspend fun connection(argument: suspend SelectedResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SelectedResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connection = mapped
    }

    /**
     * @param value Transfer Storage Blobs or Tables
     */
    @JvmName("mjwmvomhdojiccpj")
    public suspend fun dataType(`value`: Either<String, DataType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value Transfer Storage Blobs or Tables
     */
    @JvmName("lqwbrrskninugjii")
    public fun dataType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value Transfer Storage Blobs or Tables
     */
    @JvmName("mlhsmvplnvaudnme")
    public fun dataType(`value`: DataType) {
        val toBeMapped = Either.ofRight<String, DataType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value The flow type for this flow
     */
    @JvmName("yuxpnbrndwyujgqr")
    public suspend fun flowType(`value`: Either<String, FlowType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowType = mapped
    }

    /**
     * @param value The flow type for this flow
     */
    @JvmName("uafforflxhopymou")
    public fun flowType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FlowType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flowType = mapped
    }

    /**
     * @param value The flow type for this flow
     */
    @JvmName("liuhsvjrgsqdkbsg")
    public fun flowType(`value`: FlowType) {
        val toBeMapped = Either.ofRight<String, FlowType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flowType = mapped
    }

    /**
     * @param value AME, PME, or TORUS only! AKV Chain Containing SAS Token
     */
    @JvmName("ddudoxsyajjmpiro")
    public suspend fun keyVaultUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value The policies for this flow
     */
    @JvmName("qfgvtdvajeocduwh")
    public suspend fun policies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param values The policies for this flow
     */
    @JvmName("grstsnrvvvsvblkb")
    public suspend fun policies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param value The selected schema for this flow
     */
    @JvmName("uvxnotkhowvngwnn")
    public suspend fun schema(`value`: SchemaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param argument The selected schema for this flow
     */
    @JvmName("wphxrdfphcxdiair")
    public suspend fun schema(argument: suspend SchemaArgsBuilder.() -> Unit) {
        val toBeMapped = SchemaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param value Service Bus Queue ID
     */
    @JvmName("sfedlxwuwigxqsds")
    public suspend fun serviceBusQueueId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusQueueId = mapped
    }

    /**
     * @param value Status of the current flow
     */
    @JvmName("etjwejyrkgouklko")
    public suspend fun status(`value`: Either<String, FlowStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the current flow
     */
    @JvmName("qcymibocpcuyxull")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FlowStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the current flow
     */
    @JvmName("tvkqludwcxinivdj")
    public fun status(`value`: FlowStatus) {
        val toBeMapped = Either.ofRight<String, FlowStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Storage Account ID
     */
    @JvmName("mweosnjamqrdgjfr")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value Storage Account
     */
    @JvmName("ehqrqkyeyeyxscxg")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    /**
     * @param value Storage Container Name
     */
    @JvmName("fcianxqcexspvndg")
    public suspend fun storageContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerName = mapped
    }

    internal fun build(): FlowPropertiesArgs = FlowPropertiesArgs(
        connection = connection,
        dataType = dataType,
        flowType = flowType,
        keyVaultUri = keyVaultUri,
        policies = policies,
        schema = schema,
        serviceBusQueueId = serviceBusQueueId,
        status = status,
        storageAccountId = storageAccountId,
        storageAccountName = storageAccountName,
        storageContainerName = storageContainerName,
    )
}
