@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.inputs

import com.pulumi.azurenative.azuredatatransfer.inputs.ListAzureDataTransferApprovedSchemasPlainArgs.builder
import com.pulumi.azurenative.azuredatatransfer.kotlin.enums.ListApprovedSchemasDirection
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property direction The direction pipeline to filter approved schemas.
 * @property pipeline The name of the pipeline to filter approved schemas.
 */
public data class ListAzureDataTransferApprovedSchemasPlainArgs(
    public val direction: Either<String, ListApprovedSchemasDirection>? = null,
    public val pipeline: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.inputs.ListAzureDataTransferApprovedSchemasPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.azuredatatransfer.inputs.ListAzureDataTransferApprovedSchemasPlainArgs =
        com.pulumi.azurenative.azuredatatransfer.inputs.ListAzureDataTransferApprovedSchemasPlainArgs.builder()
            .direction(
                direction?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .pipeline(pipeline?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListAzureDataTransferApprovedSchemasPlainArgs].
 */
@PulumiTagMarker
public class ListAzureDataTransferApprovedSchemasPlainArgsBuilder internal constructor() {
    private var direction: Either<String, ListApprovedSchemasDirection>? = null

    private var pipeline: String? = null

    /**
     * @param value The direction pipeline to filter approved schemas.
     */
    @JvmName("vtqqfiywyqpfgfll")
    public suspend fun direction(`value`: Either<String, ListApprovedSchemasDirection>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.direction = mapped
    }

    /**
     * @param value The direction pipeline to filter approved schemas.
     */
    @JvmName("vvroscqjsxmdvojx")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ListApprovedSchemasDirection>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.direction = mapped
    }

    /**
     * @param value The direction pipeline to filter approved schemas.
     */
    @JvmName("dkvdnpvgorihxxxa")
    public fun direction(`value`: ListApprovedSchemasDirection) {
        val toBeMapped = Either.ofRight<String, ListApprovedSchemasDirection>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.direction = mapped
    }

    /**
     * @param value The name of the pipeline to filter approved schemas.
     */
    @JvmName("bxrqhgxrpvttgpkh")
    public suspend fun pipeline(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pipeline = mapped
    }

    internal fun build(): ListAzureDataTransferApprovedSchemasPlainArgs =
        ListAzureDataTransferApprovedSchemasPlainArgs(
            direction = direction,
            pipeline = pipeline,
        )
}
