@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.inputs

import com.pulumi.azurenative.azuredatatransfer.inputs.ListListPendingFlowPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The name for the connection that is to be requested.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListListPendingFlowPlainArgs(
    public val connectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.inputs.ListListPendingFlowPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.azuredatatransfer.inputs.ListListPendingFlowPlainArgs =
        com.pulumi.azurenative.azuredatatransfer.inputs.ListListPendingFlowPlainArgs.builder()
            .connectionName(connectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListListPendingFlowPlainArgs].
 */
@PulumiTagMarker
public class ListListPendingFlowPlainArgsBuilder internal constructor() {
    private var connectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name for the connection that is to be requested.
     */
    @JvmName("nhquocyhstieipig")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tntywyirsnxyarax")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListListPendingFlowPlainArgs = ListListPendingFlowPlainArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
