@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The schema object.
 * @property connectionId Connection ID associated with this schema
 * @property content Content of the schema
 * @property id ID associated with this schema
 * @property name Name of the schema
 * @property status Status of the schema
 */
public data class SchemaResponse(
    public val connectionId: String? = null,
    public val content: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuredatatransfer.outputs.SchemaResponse):
            SchemaResponse = SchemaResponse(
            connectionId = javaType.connectionId().map({ args0 -> args0 }).orElse(null),
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
