@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin

import com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Catalog].
 */
@PulumiTagMarker
public class CatalogResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CatalogArgs = CatalogArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CatalogArgsBuilder.() -> Unit) {
        val builder = CatalogArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Catalog {
        val builtJavaResource = com.pulumi.azurenative.azuresphere.Catalog(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Catalog(builtJavaResource)
    }
}

/**
 * An Azure Sphere catalog
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2024-04-01.
 * ## Example Usage
 * ### Catalogs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var catalog = new AzureNative.AzureSphere.Catalog("catalog", new()
 *     {
 *         CatalogName = "MyCatalog1",
 *         Location = "global",
 *         ResourceGroupName = "MyResourceGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuresphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuresphere.NewCatalog(ctx, "catalog", &azuresphere.CatalogArgs{
 * 			CatalogName:       pulumi.String("MyCatalog1"),
 * 			Location:          pulumi.String("global"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuresphere.Catalog;
 * import com.pulumi.azurenative.azuresphere.CatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var catalog = new Catalog("catalog", CatalogArgs.builder()
 *             .catalogName("MyCatalog1")
 *             .location("global")
 *             .resourceGroupName("MyResourceGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuresphere:Catalog MyCatalog1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}
 * ```
 */
public class Catalog internal constructor(
    override val javaResource: com.pulumi.azurenative.azuresphere.Catalog,
) : KotlinCustomResource(javaResource, CatalogMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CatalogMapper : ResourceMapper<Catalog> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azuresphere.Catalog::class == javaResource::class

    override fun map(javaResource: Resource): Catalog = Catalog(
        javaResource as
            com.pulumi.azurenative.azuresphere.Catalog,
    )
}

/**
 * @see [Catalog].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Catalog].
 */
public suspend fun catalog(name: String, block: suspend CatalogResourceBuilder.() -> Unit):
    Catalog {
    val builder = CatalogResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Catalog].
 * @param name The _unique_ name of the resulting resource.
 */
public fun catalog(name: String): Catalog {
    val builder = CatalogResourceBuilder()
    builder.name(name)
    return builder.build()
}
