@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.inputs

import com.pulumi.azurenative.azuresphere.inputs.ImageArgs.builder
import com.pulumi.azurenative.azuresphere.kotlin.enums.RegionalDataBoundary
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An image resource belonging to a catalog resource.
 * @property image Image as a UTF-8 encoded base 64 string on image create. This field contains the image URI on image reads.
 * @property imageId Image ID
 * @property regionalDataBoundary Regional data boundary for an image
 */
public data class ImageArgs(
    public val image: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val regionalDataBoundary: Output<Either<String, RegionalDataBoundary>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.inputs.ImageArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.inputs.ImageArgs =
        com.pulumi.azurenative.azuresphere.inputs.ImageArgs.builder()
            .image(image?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .regionalDataBoundary(
                regionalDataBoundary?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [ImageArgs].
 */
@PulumiTagMarker
public class ImageArgsBuilder internal constructor() {
    private var image: Output<String>? = null

    private var imageId: Output<String>? = null

    private var regionalDataBoundary: Output<Either<String, RegionalDataBoundary>>? = null

    /**
     * @param value Image as a UTF-8 encoded base 64 string on image create. This field contains the image URI on image reads.
     */
    @JvmName("gpfwwgvcyvmhtjpr")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Image ID
     */
    @JvmName("uwnpncvhgnagqfbv")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value Regional data boundary for an image
     */
    @JvmName("mqpnmcimnljibxbl")
    public suspend fun regionalDataBoundary(`value`: Output<Either<String, RegionalDataBoundary>>) {
        this.regionalDataBoundary = value
    }

    /**
     * @param value Image as a UTF-8 encoded base 64 string on image create. This field contains the image URI on image reads.
     */
    @JvmName("qfwakkwcotbpyhgs")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Image ID
     */
    @JvmName("wmnrctcsvmgtjbqj")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value Regional data boundary for an image
     */
    @JvmName("jrysqertkumoxklo")
    public suspend fun regionalDataBoundary(`value`: Either<String, RegionalDataBoundary>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionalDataBoundary = mapped
    }

    /**
     * @param value Regional data boundary for an image
     */
    @JvmName("laitvrvrxbsgpvjc")
    public fun regionalDataBoundary(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RegionalDataBoundary>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionalDataBoundary = mapped
    }

    /**
     * @param value Regional data boundary for an image
     */
    @JvmName("glapkltvddovcsil")
    public fun regionalDataBoundary(`value`: RegionalDataBoundary) {
        val toBeMapped = Either.ofRight<String, RegionalDataBoundary>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionalDataBoundary = mapped
    }

    internal fun build(): ImageArgs = ImageArgs(
        image = image,
        imageId = imageId,
        regionalDataBoundary = regionalDataBoundary,
    )
}
