@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * An device group resource belonging to a product resource.
 * @property allowCrashDumpsCollection Flag to define if the user allows for crash dump collection.
 * @property description Description of the device group.
 * @property hasDeployment Deployment status for the device group.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property osFeedType Operating system feed type of the device group.
 * @property provisioningState The status of the last operation.
 * @property regionalDataBoundary Regional data boundary for the device group.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updatePolicy Update policy of the device group.
 */
public data class DeviceGroupResponse(
    public val allowCrashDumpsCollection: String? = null,
    public val description: String? = null,
    public val hasDeployment: Boolean,
    public val id: String,
    public val name: String,
    public val osFeedType: String? = null,
    public val provisioningState: String,
    public val regionalDataBoundary: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updatePolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuresphere.outputs.DeviceGroupResponse):
            DeviceGroupResponse = DeviceGroupResponse(
            allowCrashDumpsCollection = javaType.allowCrashDumpsCollection().map({ args0 ->
                args0
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            hasDeployment = javaType.hasDeployment(),
            id = javaType.id(),
            name = javaType.name(),
            osFeedType = javaType.osFeedType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            regionalDataBoundary = javaType.regionalDataBoundary().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updatePolicy = javaType.updatePolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
