@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The response of a Deployment list operation.
 * @property nextLink The link to the next page of items
 * @property value The Deployment items on this page
 */
public data class ListCatalogDeploymentsResult(
    public val nextLink: String,
    public val `value`: List<DeploymentResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azuresphere.outputs.ListCatalogDeploymentsResult):
            ListCatalogDeploymentsResult = ListCatalogDeploymentsResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuresphere.kotlin.outputs.DeploymentResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
