@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin

import com.pulumi.azurenative.azurestack.LinkedSubscriptionArgs.builder
import com.pulumi.azurenative.azurestack.kotlin.enums.Location
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Linked Subscription information.
 * Azure REST API version: 2020-06-01-preview. Prior API version in Azure Native 1.x: 2020-06-01-preview.
 * ## Example Usage
 * ### Create or update a Linked Subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedSubscription = new AzureNative.AzureStack.LinkedSubscription("linkedSubscription", new()
 *     {
 *         LinkedSubscriptionId = "104fbb77-2b0e-476a-83de-65ad8acd1f0b",
 *         LinkedSubscriptionName = "testLinkedSubscription",
 *         Location = "eastus",
 *         RegistrationResourceId = "/subscriptions/dd8597b4-8739-4467-8b10-f8679f62bfbf/resourceGroups/azurestack/providers/Microsoft.AzureStack/registrations/testRegistration",
 *         ResourceGroup = "azurestack",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestack/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestack.NewLinkedSubscription(ctx, "linkedSubscription", &azurestack.LinkedSubscriptionArgs{
 * 			LinkedSubscriptionId:   pulumi.String("104fbb77-2b0e-476a-83de-65ad8acd1f0b"),
 * 			LinkedSubscriptionName: pulumi.String("testLinkedSubscription"),
 * 			Location:               pulumi.String("eastus"),
 * 			RegistrationResourceId: pulumi.String("/subscriptions/dd8597b4-8739-4467-8b10-f8679f62bfbf/resourceGroups/azurestack/providers/Microsoft.AzureStack/registrations/testRegistration"),
 * 			ResourceGroup:          pulumi.String("azurestack"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestack.LinkedSubscription;
 * import com.pulumi.azurenative.azurestack.LinkedSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedSubscription = new LinkedSubscription("linkedSubscription", LinkedSubscriptionArgs.builder()
 *             .linkedSubscriptionId("104fbb77-2b0e-476a-83de-65ad8acd1f0b")
 *             .linkedSubscriptionName("testLinkedSubscription")
 *             .location("eastus")
 *             .registrationResourceId("/subscriptions/dd8597b4-8739-4467-8b10-f8679f62bfbf/resourceGroups/azurestack/providers/Microsoft.AzureStack/registrations/testRegistration")
 *             .resourceGroup("azurestack")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestack:LinkedSubscription testLinkedSubscription /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/linkedSubscriptions/{linkedSubscriptionName}
 * ```
 * @property linkedSubscriptionId The identifier associated with the device subscription.
 * @property linkedSubscriptionName Name of the Linked Subscription resource.
 * @property location Location of the resource.
 * @property registrationResourceId The identifier associated with the device registration.
 * @property resourceGroup Name of the resource group.
 */
public data class LinkedSubscriptionArgs(
    public val linkedSubscriptionId: Output<String>? = null,
    public val linkedSubscriptionName: Output<String>? = null,
    public val location: Output<Either<String, Location>>? = null,
    public val registrationResourceId: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestack.LinkedSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestack.LinkedSubscriptionArgs =
        com.pulumi.azurenative.azurestack.LinkedSubscriptionArgs.builder()
            .linkedSubscriptionId(linkedSubscriptionId?.applyValue({ args0 -> args0 }))
            .linkedSubscriptionName(linkedSubscriptionName?.applyValue({ args0 -> args0 }))
            .location(
                location?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .registrationResourceId(registrationResourceId?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkedSubscriptionArgs].
 */
@PulumiTagMarker
public class LinkedSubscriptionArgsBuilder internal constructor() {
    private var linkedSubscriptionId: Output<String>? = null

    private var linkedSubscriptionName: Output<String>? = null

    private var location: Output<Either<String, Location>>? = null

    private var registrationResourceId: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    /**
     * @param value The identifier associated with the device subscription.
     */
    @JvmName("tkwjkyiknrguhpqd")
    public suspend fun linkedSubscriptionId(`value`: Output<String>) {
        this.linkedSubscriptionId = value
    }

    /**
     * @param value Name of the Linked Subscription resource.
     */
    @JvmName("rjgjxawojclmqanq")
    public suspend fun linkedSubscriptionName(`value`: Output<String>) {
        this.linkedSubscriptionName = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("luuurccebbnoverj")
    public suspend fun location(`value`: Output<Either<String, Location>>) {
        this.location = value
    }

    /**
     * @param value The identifier associated with the device registration.
     */
    @JvmName("itbklsklusvtobdh")
    public suspend fun registrationResourceId(`value`: Output<String>) {
        this.registrationResourceId = value
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("wqaobnecmxotlxci")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The identifier associated with the device subscription.
     */
    @JvmName("kxhafgutieonqfjh")
    public suspend fun linkedSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedSubscriptionId = mapped
    }

    /**
     * @param value Name of the Linked Subscription resource.
     */
    @JvmName("juwlgrpooetkjhlu")
    public suspend fun linkedSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedSubscriptionName = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("xplcfgevpcdjueoy")
    public suspend fun location(`value`: Either<String, Location>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("kwfoaamhmlsgqitm")
    public fun location(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Location>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("naoapebhrbwkoopx")
    public fun location(`value`: Location) {
        val toBeMapped = Either.ofRight<String, Location>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The identifier associated with the device registration.
     */
    @JvmName("nydnhuxcjqgtryrh")
    public suspend fun registrationResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationResourceId = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("hscqdwuwyplsrrwe")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    internal fun build(): LinkedSubscriptionArgs = LinkedSubscriptionArgs(
        linkedSubscriptionId = linkedSubscriptionId,
        linkedSubscriptionName = linkedSubscriptionName,
        location = location,
        registrationResourceId = registrationResourceId,
        resourceGroup = resourceGroup,
    )
}
