@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin

import com.pulumi.azurenative.azurestack.RegistrationArgs.builder
import com.pulumi.azurenative.azurestack.kotlin.enums.Location
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Registration information.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * Other available API versions: 2020-06-01-preview.
 * ## Example Usage
 * ### Create or update an Azure Stack registration.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registration = new AzureNative.AzureStack.Registration("registration", new()
 *     {
 *         Location = AzureNative.AzureStack.Location.@Global,
 *         RegistrationName = "testregistration",
 *         RegistrationToken = "EyjIAWXSAw5nTw9KZWWiOiJeZxZlbg9wBwvUdCiSIM9iaMVjdeLkijoinwIzyJa2Ytgtowm2yy00OdG4lTlLyJmtztHjZGfJZTC0NZK1iIWiY2XvdWRJzCi6iJy5nDy0oDk1LTNHmWeTnDUwyS05oDI0LTrINzYwoGq5mjAzziIsim1HCmtldHBsYwnLu3LuZGljYXrpB25FBmfIbgVkIJp0CNvLLCJOYXJkd2FYzuLUZM8iOlt7IM51bunvcMVZiJoYlCjcaw9ZiJPBIjNkzDJHmda3yte5ndqZMdq4YmZkZmi5oDM3OTY3ZwNMIL0SIM5PyYI6WyJLZTy0ztJJMwZKy2m0OWNLODDLMwm2zTm0ymzKyjmWySisiJA3njlHmtdlY2q4NjRjnwFIZtC1YZi5ZGyZodM3Y2vjIl0siMnwDsi6wyi2oDUZoTbiY2RhNDa0ymrKoWe4YtK5otblzWrJzGyzNCISIjmYnzC4M2vmnZdIoDRKM2i5ytfkmJlhnDc1zdhLzWm1il0sim5HBwuiOijIqzF1MTvhmDIXmIIsimrpc2SiolsioWNlZjVhnZM1otQ0nDu3NmjlN2M3zmfjzmyZMTJhZtiiLcjLZjLmmZJhmWVhytG0NTu0OTqZNWu1Mda0MZbIYtfjyijdLCj1DWlKijoinwM5Mwu3NjytMju5Os00oTIwlWi0OdmTnGzHotiWm2RjyTCxIIwiBWvTb3J5ijPbijAYZDA3M2fjNzu0YTRMZTfhodkxzDnkogY5ZtAWzdyXIiwINZcWzThLnDQ4otrJndAzZGI5MGzlYtY1ZJA5ZdfiNMQIXX1DlcJpC3n1zxiiOijZb21lB25LIIWIdmVyC2LVbiI6IJeuMcJ9",
 *         ResourceGroup = "azurestack",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestack/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestack.NewRegistration(ctx, "registration", &azurestack.RegistrationArgs{
 * 			Location:          pulumi.String(azurestack.LocationGlobal),
 * 			RegistrationName:  pulumi.String("testregistration"),
 * 			RegistrationToken: pulumi.String("EyjIAWXSAw5nTw9KZWWiOiJeZxZlbg9wBwvUdCiSIM9iaMVjdeLkijoinwIzyJa2Ytgtowm2yy00OdG4lTlLyJmtztHjZGfJZTC0NZK1iIWiY2XvdWRJzCi6iJy5nDy0oDk1LTNHmWeTnDUwyS05oDI0LTrINzYwoGq5mjAzziIsim1HCmtldHBsYwnLu3LuZGljYXrpB25FBmfIbgVkIJp0CNvLLCJOYXJkd2FYzuLUZM8iOlt7IM51bunvcMVZiJoYlCjcaw9ZiJPBIjNkzDJHmda3yte5ndqZMdq4YmZkZmi5oDM3OTY3ZwNMIL0SIM5PyYI6WyJLZTy0ztJJMwZKy2m0OWNLODDLMwm2zTm0ymzKyjmWySisiJA3njlHmtdlY2q4NjRjnwFIZtC1YZi5ZGyZodM3Y2vjIl0siMnwDsi6wyi2oDUZoTbiY2RhNDa0ymrKoWe4YtK5otblzWrJzGyzNCISIjmYnzC4M2vmnZdIoDRKM2i5ytfkmJlhnDc1zdhLzWm1il0sim5HBwuiOijIqzF1MTvhmDIXmIIsimrpc2SiolsioWNlZjVhnZM1otQ0nDu3NmjlN2M3zmfjzmyZMTJhZtiiLcjLZjLmmZJhmWVhytG0NTu0OTqZNWu1Mda0MZbIYtfjyijdLCj1DWlKijoinwM5Mwu3NjytMju5Os00oTIwlWi0OdmTnGzHotiWm2RjyTCxIIwiBWvTb3J5ijPbijAYZDA3M2fjNzu0YTRMZTfhodkxzDnkogY5ZtAWzdyXIiwINZcWzThLnDQ4otrJndAzZGI5MGzlYtY1ZJA5ZdfiNMQIXX1DlcJpC3n1zxiiOijZb21lB25LIIWIdmVyC2LVbiI6IJeuMcJ9"),
 * 			ResourceGroup:     pulumi.String("azurestack"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestack.Registration;
 * import com.pulumi.azurenative.azurestack.RegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registration = new Registration("registration", RegistrationArgs.builder()
 *             .location("global")
 *             .registrationName("testregistration")
 *             .registrationToken("EyjIAWXSAw5nTw9KZWWiOiJeZxZlbg9wBwvUdCiSIM9iaMVjdeLkijoinwIzyJa2Ytgtowm2yy00OdG4lTlLyJmtztHjZGfJZTC0NZK1iIWiY2XvdWRJzCi6iJy5nDy0oDk1LTNHmWeTnDUwyS05oDI0LTrINzYwoGq5mjAzziIsim1HCmtldHBsYwnLu3LuZGljYXrpB25FBmfIbgVkIJp0CNvLLCJOYXJkd2FYzuLUZM8iOlt7IM51bunvcMVZiJoYlCjcaw9ZiJPBIjNkzDJHmda3yte5ndqZMdq4YmZkZmi5oDM3OTY3ZwNMIL0SIM5PyYI6WyJLZTy0ztJJMwZKy2m0OWNLODDLMwm2zTm0ymzKyjmWySisiJA3njlHmtdlY2q4NjRjnwFIZtC1YZi5ZGyZodM3Y2vjIl0siMnwDsi6wyi2oDUZoTbiY2RhNDa0ymrKoWe4YtK5otblzWrJzGyzNCISIjmYnzC4M2vmnZdIoDRKM2i5ytfkmJlhnDc1zdhLzWm1il0sim5HBwuiOijIqzF1MTvhmDIXmIIsimrpc2SiolsioWNlZjVhnZM1otQ0nDu3NmjlN2M3zmfjzmyZMTJhZtiiLcjLZjLmmZJhmWVhytG0NTu0OTqZNWu1Mda0MZbIYtfjyijdLCj1DWlKijoinwM5Mwu3NjytMju5Os00oTIwlWi0OdmTnGzHotiWm2RjyTCxIIwiBWvTb3J5ijPbijAYZDA3M2fjNzu0YTRMZTfhodkxzDnkogY5ZtAWzdyXIiwINZcWzThLnDQ4otrJndAzZGI5MGzlYtY1ZJA5ZdfiNMQIXX1DlcJpC3n1zxiiOijZb21lB25LIIWIdmVyC2LVbiI6IJeuMcJ9")
 *             .resourceGroup("azurestack")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestack:Registration testregistration /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}
 * ```
 * @property location Location of the resource.
 * @property registrationName Name of the Azure Stack registration.
 * @property registrationToken The token identifying registered Azure Stack
 * @property resourceGroup Name of the resource group.
 */
public data class RegistrationArgs(
    public val location: Output<Either<String, Location>>? = null,
    public val registrationName: Output<String>? = null,
    public val registrationToken: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestack.RegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestack.RegistrationArgs =
        com.pulumi.azurenative.azurestack.RegistrationArgs.builder()
            .location(
                location?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .registrationName(registrationName?.applyValue({ args0 -> args0 }))
            .registrationToken(registrationToken?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistrationArgs].
 */
@PulumiTagMarker
public class RegistrationArgsBuilder internal constructor() {
    private var location: Output<Either<String, Location>>? = null

    private var registrationName: Output<String>? = null

    private var registrationToken: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    /**
     * @param value Location of the resource.
     */
    @JvmName("jydjqyljxwegesbp")
    public suspend fun location(`value`: Output<Either<String, Location>>) {
        this.location = value
    }

    /**
     * @param value Name of the Azure Stack registration.
     */
    @JvmName("bieyhgeyxqjixcbp")
    public suspend fun registrationName(`value`: Output<String>) {
        this.registrationName = value
    }

    /**
     * @param value The token identifying registered Azure Stack
     */
    @JvmName("ejmnmeljicwpnsgl")
    public suspend fun registrationToken(`value`: Output<String>) {
        this.registrationToken = value
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("qxpkpdrirjkwsxiq")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("fdeaqxwrdxgrwixs")
    public suspend fun location(`value`: Either<String, Location>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("nndxgqgjwwxdgvuj")
    public fun location(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Location>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("ivvfvmuurfvbqkri")
    public fun location(`value`: Location) {
        val toBeMapped = Either.ofRight<String, Location>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Azure Stack registration.
     */
    @JvmName("hipyercybudhiwvb")
    public suspend fun registrationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationName = mapped
    }

    /**
     * @param value The token identifying registered Azure Stack
     */
    @JvmName("ymjqvgrxeocevaqu")
    public suspend fun registrationToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationToken = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("bfghxdheuirmeevt")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    internal fun build(): RegistrationArgs = RegistrationArgs(
        location = location,
        registrationName = registrationName,
        registrationToken = registrationToken,
        resourceGroup = resourceGroup,
    )
}
