@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.inputs

import com.pulumi.azurenative.azurestack.inputs.GetCustomerSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customerSubscriptionName Name of the product.
 * @property registrationName Name of the Azure Stack registration.
 * @property resourceGroup Name of the resource group.
 */
public data class GetCustomerSubscriptionPlainArgs(
    public val customerSubscriptionName: String,
    public val registrationName: String,
    public val resourceGroup: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestack.inputs.GetCustomerSubscriptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestack.inputs.GetCustomerSubscriptionPlainArgs =
        com.pulumi.azurenative.azurestack.inputs.GetCustomerSubscriptionPlainArgs.builder()
            .customerSubscriptionName(customerSubscriptionName.let({ args0 -> args0 }))
            .registrationName(registrationName.let({ args0 -> args0 }))
            .resourceGroup(resourceGroup.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomerSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetCustomerSubscriptionPlainArgsBuilder internal constructor() {
    private var customerSubscriptionName: String? = null

    private var registrationName: String? = null

    private var resourceGroup: String? = null

    /**
     * @param value Name of the product.
     */
    @JvmName("nyldlbqajcfgqcnm")
    public suspend fun customerSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.customerSubscriptionName = mapped
    }

    /**
     * @param value Name of the Azure Stack registration.
     */
    @JvmName("hoiabxgtebqsvngd")
    public suspend fun registrationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registrationName = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("bnhrqvgvcctxjlfc")
    public suspend fun resourceGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroup = mapped
    }

    internal fun build(): GetCustomerSubscriptionPlainArgs = GetCustomerSubscriptionPlainArgs(
        customerSubscriptionName = customerSubscriptionName ?: throw
            PulumiNullFieldException("customerSubscriptionName"),
        registrationName = registrationName ?: throw PulumiNullFieldException("registrationName"),
        resourceGroup = resourceGroup ?: throw PulumiNullFieldException("resourceGroup"),
    )
}
