@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Registration information.
 * @property billingModel Specifies the billing mode for the Azure Stack registration.
 * @property cloudId The identifier of the registered Azure Stack.
 * @property etag The entity tag used for optimistic concurrency when modifying the resource.
 * @property id ID of the resource.
 * @property location Location of the resource.
 * @property name Name of the resource.
 * @property objectId The object identifier associated with the Azure Stack connecting to Azure.
 * @property tags Custom tags for the resource.
 * @property type Type of Resource.
 */
public data class GetRegistrationResult(
    public val billingModel: String? = null,
    public val cloudId: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val objectId: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestack.outputs.GetRegistrationResult):
            GetRegistrationResult = GetRegistrationResult(
            billingModel = javaType.billingModel().map({ args0 -> args0 }).orElse(null),
            cloudId = javaType.cloudId().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
