@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Links to product icons.
 * @property hero URI to hero icon.
 * @property large URI to large icon.
 * @property medium URI to medium icon.
 * @property small URI to small icon.
 * @property wide URI to wide icon.
 */
public data class IconUrisResponse(
    public val hero: String? = null,
    public val large: String? = null,
    public val medium: String? = null,
    public val small: String? = null,
    public val wide: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestack.outputs.IconUrisResponse):
            IconUrisResponse = IconUrisResponse(
            hero = javaType.hero().map({ args0 -> args0 }).orElse(null),
            large = javaType.large().map({ args0 -> args0 }).orElse(null),
            medium = javaType.medium().map({ args0 -> args0 }).orElse(null),
            small = javaType.small().map({ args0 -> args0 }).orElse(null),
            wide = javaType.wide().map({ args0 -> args0 }).orElse(null),
        )
    }
}
