@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Extended description about the product required for installing it into Azure Stack.
 * @property computeRole Specifies kind of compute role included in the package.
 * @property dataDiskImages List of attached data disks.
 * @property galleryPackageBlobSasUri The URI to the .azpkg file that provides information required for showing product in the gallery.
 * @property isSystemExtension Specifies if product is a Virtual Machine Extension.
 * @property osDiskImage OS disk image used by product.
 * @property productKind Specifies the kind of the product (virtualMachine or virtualMachineExtension).
 * @property supportMultipleExtensions Indicates if specified product supports multiple extensions.
 * @property uri The URI.
 * @property version Specifies product version.
 * @property vmOsType Specifies operating system used by the product.
 * @property vmScaleSetEnabled Indicates if virtual machine Scale Set is enabled in the specified product.
 */
public data class ListProductDetailsResult(
    public val computeRole: String,
    public val dataDiskImages: List<DataDiskImageResponse>,
    public val galleryPackageBlobSasUri: String,
    public val isSystemExtension: Boolean,
    public val osDiskImage: OsDiskImageResponse,
    public val productKind: String,
    public val supportMultipleExtensions: Boolean,
    public val uri: String,
    public val version: String,
    public val vmOsType: String,
    public val vmScaleSetEnabled: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestack.outputs.ListProductDetailsResult):
            ListProductDetailsResult = ListProductDetailsResult(
            computeRole = javaType.computeRole(),
            dataDiskImages = javaType.dataDiskImages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestack.kotlin.outputs.DataDiskImageResponse.Companion.toKotlin(args0)
                })
            }),
            galleryPackageBlobSasUri = javaType.galleryPackageBlobSasUri(),
            isSystemExtension = javaType.isSystemExtension(),
            osDiskImage = javaType.osDiskImage().let({ args0 ->
                com.pulumi.azurenative.azurestack.kotlin.outputs.OsDiskImageResponse.Companion.toKotlin(args0)
            }),
            productKind = javaType.productKind(),
            supportMultipleExtensions = javaType.supportMultipleExtensions(),
            uri = javaType.uri(),
            version = javaType.version(),
            vmOsType = javaType.vmOsType(),
            vmScaleSetEnabled = javaType.vmScaleSetEnabled(),
        )
    }
}
