@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ClusterDesiredPropertiesResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ClusterReportedPropertiesResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SoftwareAssurancePropertiesResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.UserAssignedIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ClusterDesiredPropertiesResponse.Companion.toKotlin as clusterDesiredPropertiesResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ClusterReportedPropertiesResponse.Companion.toKotlin as clusterReportedPropertiesResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SoftwareAssurancePropertiesResponse.Companion.toKotlin as softwareAssurancePropertiesResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin as userAssignedIdentityResponseToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.azurenative.azurestackhci.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Cluster details.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2022-01-01, 2022-09-01, 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview, 2024-01-01, 2024-02-15-preview.
 * ## Example Usage
 * ### Create cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.AzureStackHCI.Cluster("cluster", new()
 *     {
 *         AadClientId = "24a6e53d-04e5-44d2-b7cc-1b732a847dfc",
 *         AadTenantId = "7e589cc1-a8b6-4dff-91bd-5ec0fa18db94",
 *         CloudManagementEndpoint = "https://98294836-31be-4668-aeae-698667faf99b.waconazure.com",
 *         ClusterName = "myCluster",
 *         Location = "East US",
 *         ResourceGroupName = "test-rg",
 *         Type = AzureNative.AzureStackHCI.ManagedServiceIdentityType.SystemAssigned,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewCluster(ctx, "cluster", &azurestackhci.ClusterArgs{
 * 			AadClientId:             pulumi.String("24a6e53d-04e5-44d2-b7cc-1b732a847dfc"),
 * 			AadTenantId:             pulumi.String("7e589cc1-a8b6-4dff-91bd-5ec0fa18db94"),
 * 			CloudManagementEndpoint: pulumi.String("https://98294836-31be-4668-aeae-698667faf99b.waconazure.com"),
 * 			ClusterName:             pulumi.String("myCluster"),
 * 			Location:                pulumi.String("East US"),
 * 			ResourceGroupName:       pulumi.String("test-rg"),
 * 			Type:                    pulumi.String(azurestackhci.ManagedServiceIdentityTypeSystemAssigned),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.Cluster;
 * import com.pulumi.azurenative.azurestackhci.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .aadClientId("24a6e53d-04e5-44d2-b7cc-1b732a847dfc")
 *             .aadTenantId("7e589cc1-a8b6-4dff-91bd-5ec0fa18db94")
 *             .cloudManagementEndpoint("https://98294836-31be-4668-aeae-698667faf99b.waconazure.com")
 *             .clusterName("myCluster")
 *             .location("East US")
 *             .resourceGroupName("test-rg")
 *             .type("SystemAssigned")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:Cluster myCluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * Object id of cluster AAD identity.
     */
    public val aadApplicationObjectId: Output<String>?
        get() = javaResource.aadApplicationObjectId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * App id of cluster AAD identity.
     */
    public val aadClientId: Output<String>?
        get() = javaResource.aadClientId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Id of cluster identity service principal.
     */
    public val aadServicePrincipalObjectId: Output<String>?
        get() = javaResource.aadServicePrincipalObjectId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Tenant id of cluster AAD identity.
     */
    public val aadTenantId: Output<String>?
        get() = javaResource.aadTenantId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of billing applied to the resource.
     */
    public val billingModel: Output<String>
        get() = javaResource.billingModel().applyValue({ args0 -> args0 })

    /**
     * Unique, immutable resource id.
     */
    public val cloudId: Output<String>
        get() = javaResource.cloudId().applyValue({ args0 -> args0 })

    /**
     * Endpoint configured for management from the Azure portal.
     */
    public val cloudManagementEndpoint: Output<String>?
        get() = javaResource.cloudManagementEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Desired properties of the cluster.
     */
    public val desiredProperties: Output<ClusterDesiredPropertiesResponse>?
        get() = javaResource.desiredProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterDesiredPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Most recent billing meter timestamp.
     */
    public val lastBillingTimestamp: Output<String>
        get() = javaResource.lastBillingTimestamp().applyValue({ args0 -> args0 })

    /**
     * Most recent cluster sync timestamp.
     */
    public val lastSyncTimestamp: Output<String>
        get() = javaResource.lastSyncTimestamp().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
     */
    public val principalId: Output<String>
        get() = javaResource.principalId().applyValue({ args0 -> args0 })

    /**
     * Provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * First cluster sync timestamp.
     */
    public val registrationTimestamp: Output<String>
        get() = javaResource.registrationTimestamp().applyValue({ args0 -> args0 })

    /**
     * Properties reported by cluster agent.
     */
    public val reportedProperties: Output<ClusterReportedPropertiesResponse>
        get() = javaResource.reportedProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterReportedPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Object id of RP Service Principal
     */
    public val resourceProviderObjectId: Output<String>
        get() = javaResource.resourceProviderObjectId().applyValue({ args0 -> args0 })

    /**
     * Region specific DataPath Endpoint of the cluster.
     */
    public val serviceEndpoint: Output<String>
        get() = javaResource.serviceEndpoint().applyValue({ args0 -> args0 })

    /**
     * Software Assurance properties of the cluster.
     */
    public val softwareAssuranceProperties: Output<SoftwareAssurancePropertiesResponse>?
        get() = javaResource.softwareAssuranceProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> softwareAssurancePropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Status of the cluster agent.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Number of days remaining in the trial period.
     */
    public val trialDaysRemaining: Output<Double>
        get() = javaResource.trialDaysRemaining().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    public val userAssignedIdentities: Output<Map<String, UserAssignedIdentityResponse>>?
        get() = javaResource.userAssignedIdentities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            userAssignedIdentityResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.azurenative.azurestackhci.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit):
    Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
