@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.DeviceConfigurationResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.DeviceConfigurationResponse.Companion.toKotlin as deviceConfigurationResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [EdgeDevice].
 */
@PulumiTagMarker
public class EdgeDeviceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EdgeDeviceArgs = EdgeDeviceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EdgeDeviceArgsBuilder.() -> Unit) {
        val builder = EdgeDeviceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EdgeDevice {
        val builtJavaResource = com.pulumi.azurenative.azurestackhci.EdgeDevice(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EdgeDevice(builtJavaResource)
    }
}

/**
 * Edge device resource
 * Azure REST API version: 2023-08-01-preview.
 * Other available API versions: 2023-11-01-preview, 2024-01-01, 2024-02-15-preview.
 * ## Example Usage
 * ### Create Edge Device
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var edgeDevice = new AzureNative.AzureStackHCI.EdgeDevice("edgeDevice", new()
 *     {
 *         DeviceConfiguration = new AzureNative.AzureStackHCI.Inputs.DeviceConfigurationArgs
 *         {
 *             DeviceMetadata = "",
 *             NicDetails = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.NicDetailArgs
 *                 {
 *                     AdapterName = "ethernet",
 *                     ComponentId = "VMBUS{f8615163-df3e-46c5-913f-f2d2f965ed0g} ",
 *                     DefaultGateway = "10.10.10.1",
 *                     DefaultIsolationId = "0",
 *                     DnsServers = new[]
 *                     {
 *                         "100.10.10.1",
 *                     },
 *                     DriverVersion = "10.0.20348.1547 ",
 *                     InterfaceDescription = "NDIS 6.70 ",
 *                     Ip4Address = "10.10.10.10",
 *                     SubnetMask = "255.255.255.0",
 *                 },
 *             },
 *         },
 *         EdgeDeviceName = "default",
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/ArcInstance-rg/providers/Microsoft.HybridCompute/machines/Node-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewEdgeDevice(ctx, "edgeDevice", &azurestackhci.EdgeDeviceArgs{
 * 			DeviceConfiguration: &azurestackhci.DeviceConfigurationArgs{
 * 				DeviceMetadata: pulumi.String(""),
 * 				NicDetails: azurestackhci.NicDetailArray{
 * 					&azurestackhci.NicDetailArgs{
 * 						AdapterName:        pulumi.String("ethernet"),
 * 						ComponentId:        pulumi.String("VMBUS{f8615163-df3e-46c5-913f-f2d2f965ed0g} "),
 * 						DefaultGateway:     pulumi.String("10.10.10.1"),
 * 						DefaultIsolationId: pulumi.String("0"),
 * 						DnsServers: pulumi.StringArray{
 * 							pulumi.String("100.10.10.1"),
 * 						},
 * 						DriverVersion:        pulumi.String("10.0.20348.1547 "),
 * 						InterfaceDescription: pulumi.String("NDIS 6.70 "),
 * 						Ip4Address:           pulumi.String("10.10.10.10"),
 * 						SubnetMask:           pulumi.String("255.255.255.0"),
 * 					},
 * 				},
 * 			},
 * 			EdgeDeviceName: pulumi.String("default"),
 * 			ResourceUri:    pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/ArcInstance-rg/providers/Microsoft.HybridCompute/machines/Node-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.EdgeDevice;
 * import com.pulumi.azurenative.azurestackhci.EdgeDeviceArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.DeviceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var edgeDevice = new EdgeDevice("edgeDevice", EdgeDeviceArgs.builder()
 *             .deviceConfiguration(DeviceConfigurationArgs.builder()
 *                 .deviceMetadata("")
 *                 .nicDetails(NicDetailArgs.builder()
 *                     .adapterName("ethernet")
 *                     .componentId("VMBUS{f8615163-df3e-46c5-913f-f2d2f965ed0g} ")
 *                     .defaultGateway("10.10.10.1")
 *                     .defaultIsolationId("0")
 *                     .dnsServers("100.10.10.1")
 *                     .driverVersion("10.0.20348.1547 ")
 *                     .interfaceDescription("NDIS 6.70 ")
 *                     .ip4Address("10.10.10.10")
 *                     .subnetMask("255.255.255.0")
 *                     .build())
 *                 .build())
 *             .edgeDeviceName("default")
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/ArcInstance-rg/providers/Microsoft.HybridCompute/machines/Node-1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:EdgeDevice default /{resourceUri}/providers/Microsoft.AzureStackHCI/edgeDevices/{edgeDeviceName}
 * ```
 */
public class EdgeDevice internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.EdgeDevice,
) : KotlinCustomResource(javaResource, EdgeDeviceMapper) {
    /**
     * Device Configuration
     */
    public val deviceConfiguration: Output<DeviceConfigurationResponse>
        get() = javaResource.deviceConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                deviceConfigurationResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of edgeDevice resource
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EdgeDeviceMapper : ResourceMapper<EdgeDevice> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.EdgeDevice::class == javaResource::class

    override fun map(javaResource: Resource): EdgeDevice = EdgeDevice(
        javaResource as
            com.pulumi.azurenative.azurestackhci.EdgeDevice,
    )
}

/**
 * @see [EdgeDevice].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EdgeDevice].
 */
public suspend fun edgeDevice(name: String, block: suspend EdgeDeviceResourceBuilder.() -> Unit):
    EdgeDevice {
    val builder = EdgeDeviceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EdgeDevice].
 * @param name The _unique_ name of the resulting resource.
 */
public fun edgeDevice(name: String): EdgeDevice {
    val builder = EdgeDeviceResourceBuilder()
    builder.name(name)
    return builder.build()
}
