@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.GalleryImageArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.CloudInitDataSource
import com.pulumi.azurenative.azurestackhci.kotlin.enums.HyperVGeneration
import com.pulumi.azurenative.azurestackhci.kotlin.enums.OperatingSystemTypes
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GalleryImageIdentifierArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GalleryImageIdentifierArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GalleryImageVersionArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GalleryImageVersionArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The gallery images resource definition.
 * Azure REST API version: 2022-12-15-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2024-01-01.
 * ## Example Usage
 * ### PutGalleryImage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryImage = new AzureNative.AzureStackHCI.GalleryImage("galleryImage", new()
 *     {
 *         ContainerName = "Default_Container",
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         GalleryImageName = "test-gallery-image",
 *         ImagePath = "C:\\test.vhdx",
 *         Location = "West US2",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewGalleryImage(ctx, "galleryImage", &azurestackhci.GalleryImageArgs{
 * 			ContainerName: pulumi.String("Default_Container"),
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			GalleryImageName:  pulumi.String("test-gallery-image"),
 * 			ImagePath:         pulumi.String("C:\\test.vhdx"),
 * 			Location:          pulumi.String("West US2"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.GalleryImage;
 * import com.pulumi.azurenative.azurestackhci.GalleryImageArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryImage = new GalleryImage("galleryImage", GalleryImageArgs.builder()
 *             .containerName("Default_Container")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .galleryImageName("test-gallery-image")
 *             .imagePath("C:\\test.vhdx")
 *             .location("West US2")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:GalleryImage test-gallery-image /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/galleryImages/{galleryImageName}
 * ```
 * @property cloudInitDataSource Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
 * @property containerName Container Name for storage container
 * @property extendedLocation The extendedLocation of the resource.
 * @property galleryImageName Name of the gallery image
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine [V1, V2]
 * @property identifier This is the gallery image definition identifier.
 * @property imagePath location of the image the gallery image should be created from
 * @property location The geo-location where the resource lives
 * @property osType Operating system type that the gallery image uses [Windows, Linux]
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property version Specifies information about the gallery image version that you want to create or update.
 */
public data class GalleryImageArgs(
    public val cloudInitDataSource: Output<Either<String, CloudInitDataSource>>? = null,
    public val containerName: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val galleryImageName: Output<String>? = null,
    public val hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null,
    public val identifier: Output<GalleryImageIdentifierArgs>? = null,
    public val imagePath: Output<String>? = null,
    public val location: Output<String>? = null,
    public val osType: Output<OperatingSystemTypes>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<GalleryImageVersionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.GalleryImageArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.GalleryImageArgs =
        com.pulumi.azurenative.azurestackhci.GalleryImageArgs.builder()
            .cloudInitDataSource(
                cloudInitDataSource?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .galleryImageName(galleryImageName?.applyValue({ args0 -> args0 }))
            .hyperVGeneration(
                hyperVGeneration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .identifier(identifier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imagePath(imagePath?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .osType(osType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GalleryImageArgs].
 */
@PulumiTagMarker
public class GalleryImageArgsBuilder internal constructor() {
    private var cloudInitDataSource: Output<Either<String, CloudInitDataSource>>? = null

    private var containerName: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var galleryImageName: Output<String>? = null

    private var hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null

    private var identifier: Output<GalleryImageIdentifierArgs>? = null

    private var imagePath: Output<String>? = null

    private var location: Output<String>? = null

    private var osType: Output<OperatingSystemTypes>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<GalleryImageVersionArgs>? = null

    /**
     * @param value Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
     */
    @JvmName("ragdcyjjfijfgyhg")
    public suspend fun cloudInitDataSource(`value`: Output<Either<String, CloudInitDataSource>>) {
        this.cloudInitDataSource = value
    }

    /**
     * @param value Container Name for storage container
     */
    @JvmName("damouraywjddswwg")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("mfgvrewjuipekbgk")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Name of the gallery image
     */
    @JvmName("tmpiwetgxamramxa")
    public suspend fun galleryImageName(`value`: Output<String>) {
        this.galleryImageName = value
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine [V1, V2]
     */
    @JvmName("lrrfdbjtxuwcqcnr")
    public suspend fun hyperVGeneration(`value`: Output<Either<String, HyperVGeneration>>) {
        this.hyperVGeneration = value
    }

    /**
     * @param value This is the gallery image definition identifier.
     */
    @JvmName("cwrxrytxgymsxvfb")
    public suspend fun identifier(`value`: Output<GalleryImageIdentifierArgs>) {
        this.identifier = value
    }

    /**
     * @param value location of the image the gallery image should be created from
     */
    @JvmName("idlwgyesqgbkodju")
    public suspend fun imagePath(`value`: Output<String>) {
        this.imagePath = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rgutvugqlgpgdpbv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Operating system type that the gallery image uses [Windows, Linux]
     */
    @JvmName("lbadvisqypfmvbpo")
    public suspend fun osType(`value`: Output<OperatingSystemTypes>) {
        this.osType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("shdbpyhmhlnkwccy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aqjhslbwhjskpqkw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies information about the gallery image version that you want to create or update.
     */
    @JvmName("vgesevoaqqkagmlp")
    public suspend fun version(`value`: Output<GalleryImageVersionArgs>) {
        this.version = value
    }

    /**
     * @param value Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
     */
    @JvmName("htssbrekjwhbstjq")
    public suspend fun cloudInitDataSource(`value`: Either<String, CloudInitDataSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudInitDataSource = mapped
    }

    /**
     * @param value Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
     */
    @JvmName("xyjnadopsvncknyq")
    public fun cloudInitDataSource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CloudInitDataSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudInitDataSource = mapped
    }

    /**
     * @param value Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
     */
    @JvmName("qifwqipomipunvwn")
    public fun cloudInitDataSource(`value`: CloudInitDataSource) {
        val toBeMapped = Either.ofRight<String, CloudInitDataSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudInitDataSource = mapped
    }

    /**
     * @param value Container Name for storage container
     */
    @JvmName("exaqfjykqcvaltrh")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("xyxhvrtbecsxwedg")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("spxuxpgkqjkvskuo")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Name of the gallery image
     */
    @JvmName("ysfafqybucqeqjch")
    public suspend fun galleryImageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryImageName = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine [V1, V2]
     */
    @JvmName("cgvetrgmjnfxvewq")
    public suspend fun hyperVGeneration(`value`: Either<String, HyperVGeneration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine [V1, V2]
     */
    @JvmName("rxnrxkldhyxjopin")
    public fun hyperVGeneration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine [V1, V2]
     */
    @JvmName("lrfnwvnachkpstlb")
    public fun hyperVGeneration(`value`: HyperVGeneration) {
        val toBeMapped = Either.ofRight<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value This is the gallery image definition identifier.
     */
    @JvmName("taxtofjtiepmttuh")
    public suspend fun identifier(`value`: GalleryImageIdentifierArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param argument This is the gallery image definition identifier.
     */
    @JvmName("lvvlgbhssuarrxrr")
    public suspend fun identifier(argument: suspend GalleryImageIdentifierArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryImageIdentifierArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identifier = mapped
    }

    /**
     * @param value location of the image the gallery image should be created from
     */
    @JvmName("kevtssmbxoybxfpe")
    public suspend fun imagePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePath = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gemvnoyfpxoifaic")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Operating system type that the gallery image uses [Windows, Linux]
     */
    @JvmName("relfiyjpeakylcgb")
    public suspend fun osType(`value`: OperatingSystemTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jngssdqnyjcssgdq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pdlolrpdwdslxyph")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("njdpubrnxyywjsnt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies information about the gallery image version that you want to create or update.
     */
    @JvmName("wklmmbtgoyftdiyw")
    public suspend fun version(`value`: GalleryImageVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param argument Specifies information about the gallery image version that you want to create or update.
     */
    @JvmName("tyhfjauglfxwislk")
    public suspend fun version(argument: suspend GalleryImageVersionArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryImageVersionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.version = mapped
    }

    internal fun build(): GalleryImageArgs = GalleryImageArgs(
        cloudInitDataSource = cloudInitDataSource,
        containerName = containerName,
        extendedLocation = extendedLocation,
        galleryImageName = galleryImageName,
        hyperVGeneration = hyperVGeneration,
        identifier = identifier,
        imagePath = imagePath,
        location = location,
        osType = osType,
        resourceGroupName = resourceGroupName,
        tags = tags,
        version = version,
    )
}
