@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.HybridIdentityMetadatumArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the HybridIdentityMetadata.
 * Azure REST API version: 2022-12-15-preview.
 * ## Example Usage
 * ### CreateHybridIdentityMetadata
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridIdentityMetadatum = new AzureNative.AzureStackHCI.HybridIdentityMetadatum("hybridIdentityMetadatum", new()
 *     {
 *         MetadataName = "default",
 *         PublicKey = "8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2",
 *         ResourceGroupName = "testrg",
 *         VirtualMachineName = "ContosoVm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewHybridIdentityMetadatum(ctx, "hybridIdentityMetadatum", &azurestackhci.HybridIdentityMetadatumArgs{
 * 			MetadataName:       pulumi.String("default"),
 * 			PublicKey:          pulumi.String("8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			VirtualMachineName: pulumi.String("ContosoVm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.HybridIdentityMetadatum;
 * import com.pulumi.azurenative.azurestackhci.HybridIdentityMetadatumArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridIdentityMetadatum = new HybridIdentityMetadatum("hybridIdentityMetadatum", HybridIdentityMetadatumArgs.builder()
 *             .metadataName("default")
 *             .publicKey("8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2")
 *             .resourceGroupName("testrg")
 *             .virtualMachineName("ContosoVm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:HybridIdentityMetadatum default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualMachines/{virtualMachineName}/hybridIdentityMetadata/{metadataName}
 * ```
 * @property metadataName Name of the hybridIdentityMetadata.
 * @property publicKey The Public Key.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceUid The unique identifier for the resource.
 * @property virtualMachineName Name of the vm.
 */
public data class HybridIdentityMetadatumArgs(
    public val metadataName: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceUid: Output<String>? = null,
    public val virtualMachineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.HybridIdentityMetadatumArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.HybridIdentityMetadatumArgs =
        com.pulumi.azurenative.azurestackhci.HybridIdentityMetadatumArgs.builder()
            .metadataName(metadataName?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceUid(resourceUid?.applyValue({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridIdentityMetadatumArgs].
 */
@PulumiTagMarker
public class HybridIdentityMetadatumArgsBuilder internal constructor() {
    private var metadataName: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceUid: Output<String>? = null

    private var virtualMachineName: Output<String>? = null

    /**
     * @param value Name of the hybridIdentityMetadata.
     */
    @JvmName("ybjjyyacvupcvolu")
    public suspend fun metadataName(`value`: Output<String>) {
        this.metadataName = value
    }

    /**
     * @param value The Public Key.
     */
    @JvmName("jamwjgmsyupvrkjx")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("elvlronnoqieovlg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The unique identifier for the resource.
     */
    @JvmName("tcaysarhjqpyjotx")
    public suspend fun resourceUid(`value`: Output<String>) {
        this.resourceUid = value
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("ptjqkmgmwqbkygxq")
    public suspend fun virtualMachineName(`value`: Output<String>) {
        this.virtualMachineName = value
    }

    /**
     * @param value Name of the hybridIdentityMetadata.
     */
    @JvmName("rhskrpyivpovkbnu")
    public suspend fun metadataName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataName = mapped
    }

    /**
     * @param value The Public Key.
     */
    @JvmName("oaktqetqfdrvldph")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nvawvypcgymsnjru")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The unique identifier for the resource.
     */
    @JvmName("trbwruttsghrnggi")
    public suspend fun resourceUid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUid = mapped
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("kiklkaoehvjdgfrc")
    public suspend fun virtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineName = mapped
    }

    internal fun build(): HybridIdentityMetadatumArgs = HybridIdentityMetadatumArgs(
        metadataName = metadataName,
        publicKey = publicKey,
        resourceGroupName = resourceGroupName,
        resourceUid = resourceUid,
        virtualMachineName = virtualMachineName,
    )
}
