@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.LogicalNetworkPropertiesResponseDhcpOptions
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.LogicalNetworkStatusResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SubnetResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.LogicalNetworkPropertiesResponseDhcpOptions.Companion.toKotlin as logicalNetworkPropertiesResponseDhcpOptionsToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.LogicalNetworkStatusResponse.Companion.toKotlin as logicalNetworkStatusResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SubnetResponse.Companion.toKotlin as subnetResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [LogicalNetwork].
 */
@PulumiTagMarker
public class LogicalNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogicalNetworkArgs = LogicalNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogicalNetworkArgsBuilder.() -> Unit) {
        val builder = LogicalNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LogicalNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.azurestackhci.LogicalNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LogicalNetwork(builtJavaResource)
    }
}

/**
 * The logical network resource definition.
 * Azure REST API version: 2023-09-01-preview.
 * Other available API versions: 2024-01-01.
 * ## Example Usage
 * ### PutLogicalNetwork
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var logicalNetwork = new AzureNative.AzureStackHCI.LogicalNetwork("logicalNetwork", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         Location = "West US2",
 *         LogicalNetworkName = "test-lnet",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewLogicalNetwork(ctx, "logicalNetwork", &azurestackhci.LogicalNetworkArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			Location:           pulumi.String("West US2"),
 * 			LogicalNetworkName: pulumi.String("test-lnet"),
 * 			ResourceGroupName:  pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.LogicalNetwork;
 * import com.pulumi.azurenative.azurestackhci.LogicalNetworkArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var logicalNetwork = new LogicalNetwork("logicalNetwork", LogicalNetworkArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("West US2")
 *             .logicalNetworkName("test-lnet")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:LogicalNetwork test-lnet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/logicalNetworks/{logicalNetworkName}
 * ```
 */
public class LogicalNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.LogicalNetwork,
) : KotlinCustomResource(javaResource, LogicalNetworkMapper) {
    /**
     * DhcpOptions contains an array of DNS servers available to VMs deployed in the logical network. Standard DHCP option for a subnet overrides logical network DHCP options.
     */
    public val dhcpOptions: Output<LogicalNetworkPropertiesResponseDhcpOptions>?
        get() = javaResource.dhcpOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    logicalNetworkPropertiesResponseDhcpOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The extendedLocation of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the logical network.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The observed state of logical networks
     */
    public val status: Output<LogicalNetworkStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                logicalNetworkStatusResponseToKotlin(args0)
            })
        })

    /**
     * Subnet - list of subnets under the logical network
     */
    public val subnets: Output<List<SubnetResponse>>?
        get() = javaResource.subnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> subnetResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * name of the network switch to be used for VMs
     */
    public val vmSwitchName: Output<String>?
        get() = javaResource.vmSwitchName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object LogicalNetworkMapper : ResourceMapper<LogicalNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.LogicalNetwork::class == javaResource::class

    override fun map(javaResource: Resource): LogicalNetwork = LogicalNetwork(
        javaResource as
            com.pulumi.azurenative.azurestackhci.LogicalNetwork,
    )
}

/**
 * @see [LogicalNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogicalNetwork].
 */
public suspend fun logicalNetwork(
    name: String,
    block: suspend LogicalNetworkResourceBuilder.() -> Unit,
): LogicalNetwork {
    val builder = LogicalNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogicalNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logicalNetwork(name: String): LogicalNetwork {
    val builder = LogicalNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
