@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.UpdatePrerequisiteResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.UpdatePrerequisiteResponse.Companion.toKotlin as updatePrerequisiteResponseToKotlin

/**
 * Builder for [Update].
 */
@PulumiTagMarker
public class UpdateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UpdateArgs = UpdateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UpdateArgsBuilder.() -> Unit) {
        val builder = UpdateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Update {
        val builtJavaResource = com.pulumi.azurenative.azurestackhci.Update(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Update(builtJavaResource)
    }
}

/**
 * Update details
 * Azure REST API version: 2023-03-01.
 * Other available API versions: 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview, 2024-01-01, 2024-02-15-preview.
 * ## Example Usage
 * ### Put a specific update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var update = new AzureNative.AzureStackHCI.Update("update", new()
 *     {
 *         AdditionalProperties = "additional properties",
 *         AvailabilityType = AzureNative.AzureStackHCI.AvailabilityType.Local,
 *         ClusterName = "testcluster",
 *         Description = "AzS Update 4.2203.2.32",
 *         DisplayName = "AzS Update - 4.2203.2.32",
 *         InstalledDate = "2022-04-06T14:08:18.254Z",
 *         NotifyMessage = "Brief message with instructions for updates of AvailabilityType Notify",
 *         PackagePath = "\\\\SU1FileServer\\SU1_Infrastructure_2\\Updates\\Packages\\Microsoft4.2203.2.32",
 *         PackageSizeInMb = 18858,
 *         PackageType = "Infrastructure",
 *         Prerequisites = new[]
 *         {
 *             new AzureNative.AzureStackHCI.Inputs.UpdatePrerequisiteArgs
 *             {
 *                 PackageName = "update package name",
 *                 UpdateType = "update type",
 *                 Version = "prerequisite version",
 *             },
 *         },
 *         ProgressPercentage = 0,
 *         Publisher = "Microsoft",
 *         ReleaseLink = "https://docs.microsoft.com/azure-stack/operator/release-notes?view=azs-2203",
 *         ResourceGroupName = "testrg",
 *         State = AzureNative.AzureStackHCI.State.Installed,
 *         UpdateName = "Microsoft4.2203.2.32",
 *         Version = "4.2203.2.32",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewUpdate(ctx, "update", &azurestackhci.UpdateArgs{
 * 			AdditionalProperties: pulumi.String("additional properties"),
 * 			AvailabilityType:     pulumi.String(azurestackhci.AvailabilityTypeLocal),
 * 			ClusterName:          pulumi.String("testcluster"),
 * 			Description:          pulumi.String("AzS Update 4.2203.2.32"),
 * 			DisplayName:          pulumi.String("AzS Update - 4.2203.2.32"),
 * 			InstalledDate:        pulumi.String("2022-04-06T14:08:18.254Z"),
 * 			NotifyMessage:        pulumi.String("Brief message with instructions for updates of AvailabilityType Notify"),
 * 			PackagePath:          pulumi.String("\\\\SU1FileServer\\SU1_Infrastructure_2\\Updates\\Packages\\Microsoft4.2203.2.32"),
 * 			PackageSizeInMb:      pulumi.Float64(18858),
 * 			PackageType:          pulumi.String("Infrastructure"),
 * 			Prerequisites: azurestackhci.UpdatePrerequisiteArray{
 * 				&azurestackhci.UpdatePrerequisiteArgs{
 * 					PackageName: pulumi.String("update package name"),
 * 					UpdateType:  pulumi.String("update type"),
 * 					Version:     pulumi.String("prerequisite version"),
 * 				},
 * 			},
 * 			ProgressPercentage: pulumi.Float64(0),
 * 			Publisher:          pulumi.String("Microsoft"),
 * 			ReleaseLink:        pulumi.String("https://docs.microsoft.com/azure-stack/operator/release-notes?view=azs-2203"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			State:              pulumi.String(azurestackhci.StateInstalled),
 * 			UpdateName:         pulumi.String("Microsoft4.2203.2.32"),
 * 			Version:            pulumi.String("4.2203.2.32"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.Update;
 * import com.pulumi.azurenative.azurestackhci.UpdateArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.UpdatePrerequisiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var update = new Update("update", UpdateArgs.builder()
 *             .additionalProperties("additional properties")
 *             .availabilityType("Local")
 *             .clusterName("testcluster")
 *             .description("AzS Update 4.2203.2.32")
 *             .displayName("AzS Update - 4.2203.2.32")
 *             .installedDate("2022-04-06T14:08:18.254Z")
 *             .notifyMessage("Brief message with instructions for updates of AvailabilityType Notify")
 *             .packagePath("\\\\SU1FileServer\\SU1_Infrastructure_2\\Updates\\Packages\\Microsoft4.2203.2.32")
 *             .packageSizeInMb(18858)
 *             .packageType("Infrastructure")
 *             .prerequisites(UpdatePrerequisiteArgs.builder()
 *                 .packageName("update package name")
 *                 .updateType("update type")
 *                 .version("prerequisite version")
 *                 .build())
 *             .progressPercentage(0)
 *             .publisher("Microsoft")
 *             .releaseLink("https://docs.microsoft.com/azure-stack/operator/release-notes?view=azs-2203")
 *             .resourceGroupName("testrg")
 *             .state("Installed")
 *             .updateName("Microsoft4.2203.2.32")
 *             .version("4.2203.2.32")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:Update Microsoft4.2203.2.32 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}
 * ```
 */
public class Update internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.Update,
) : KotlinCustomResource(javaResource, UpdateMapper) {
    /**
     * Extensible KV pairs serialized as a string. This is currently used to report the stamp OEM family and hardware model information when an update is flagged as Invalid for the stamp based on OEM type.
     */
    public val additionalProperties: Output<String>?
        get() = javaResource.additionalProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates the way the update content can be downloaded.
     */
    public val availabilityType: Output<String>?
        get() = javaResource.availabilityType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the update.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Display name of the Update
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Last time the package-specific checks were run.
     */
    public val healthCheckDate: Output<String>?
        get() = javaResource.healthCheckDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date that the update was installed.
     */
    public val installedDate: Output<String>?
        get() = javaResource.installedDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Brief message with instructions for updates of AvailabilityType Notify.
     */
    public val notifyMessage: Output<String>?
        get() = javaResource.notifyMessage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Path where the update package is available.
     */
    public val packagePath: Output<String>?
        get() = javaResource.packagePath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Size of the package. This value is a combination of the size from update metadata and size of the payload that results from the live scan operation for OS update content.
     */
    public val packageSizeInMb: Output<Double>?
        get() = javaResource.packageSizeInMb().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Customer-visible type of the update.
     */
    public val packageType: Output<String>?
        get() = javaResource.packageType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
     */
    public val prerequisites: Output<List<UpdatePrerequisiteResponse>>?
        get() = javaResource.prerequisites().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        updatePrerequisiteResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Progress percentage of ongoing operation. Currently this property is only valid when the update is in the Downloading state, where it maps to how much of the update content has been downloaded.
     */
    public val progressPercentage: Output<Double>?
        get() = javaResource.progressPercentage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the Updates proxy resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Publisher of the update package.
     */
    public val publisher: Output<String>?
        get() = javaResource.publisher().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Link to release notes for the update.
     */
    public val releaseLink: Output<String>?
        get() = javaResource.releaseLink().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * State of the update as it relates to this stamp.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of the update.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object UpdateMapper : ResourceMapper<Update> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.Update::class == javaResource::class

    override fun map(javaResource: Resource): Update = Update(
        javaResource as
            com.pulumi.azurenative.azurestackhci.Update,
    )
}

/**
 * @see [Update].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Update].
 */
public suspend fun update(name: String, block: suspend UpdateResourceBuilder.() -> Unit): Update {
    val builder = UpdateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Update].
 * @param name The _unique_ name of the resulting resource.
 */
public fun update(name: String): Update {
    val builder = UpdateResourceBuilder()
    builder.name(name)
    return builder.build()
}
