@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UpdateSummary].
 */
@PulumiTagMarker
public class UpdateSummaryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UpdateSummaryArgs = UpdateSummaryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UpdateSummaryArgsBuilder.() -> Unit) {
        val builder = UpdateSummaryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UpdateSummary {
        val builtJavaResource =
            com.pulumi.azurenative.azurestackhci.UpdateSummary(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return UpdateSummary(builtJavaResource)
    }
}

/**
 * Get the update summaries for the cluster
 * Azure REST API version: 2023-03-01.
 * Other available API versions: 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview, 2024-01-01, 2024-02-15-preview.
 * ## Example Usage
 * ### Put Update summaries under cluster resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var updateSummary = new AzureNative.AzureStackHCI.UpdateSummary("updateSummary", new()
 *     {
 *         ClusterName = "testcluster",
 *         CurrentVersion = "4.2203.2.32",
 *         HardwareModel = "PowerEdge R730xd",
 *         LastChecked = "2022-04-07T18:04:07Z",
 *         LastUpdated = "2022-04-06T14:08:18.254Z",
 *         OemFamily = "DellEMC",
 *         ResourceGroupName = "testrg",
 *         State = AzureNative.AzureStackHCI.UpdateSummariesPropertiesState.AppliedSuccessfully,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewUpdateSummary(ctx, "updateSummary", &azurestackhci.UpdateSummaryArgs{
 * 			ClusterName:       pulumi.String("testcluster"),
 * 			CurrentVersion:    pulumi.String("4.2203.2.32"),
 * 			HardwareModel:     pulumi.String("PowerEdge R730xd"),
 * 			LastChecked:       pulumi.String("2022-04-07T18:04:07Z"),
 * 			LastUpdated:       pulumi.String("2022-04-06T14:08:18.254Z"),
 * 			OemFamily:         pulumi.String("DellEMC"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			State:             pulumi.String(azurestackhci.UpdateSummariesPropertiesStateAppliedSuccessfully),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.UpdateSummary;
 * import com.pulumi.azurenative.azurestackhci.UpdateSummaryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var updateSummary = new UpdateSummary("updateSummary", UpdateSummaryArgs.builder()
 *             .clusterName("testcluster")
 *             .currentVersion("4.2203.2.32")
 *             .hardwareModel("PowerEdge R730xd")
 *             .lastChecked("2022-04-07T18:04:07Z")
 *             .lastUpdated("2022-04-06T14:08:18.254Z")
 *             .oemFamily("DellEMC")
 *             .resourceGroupName("testrg")
 *             .state("AppliedSuccessfully")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:UpdateSummary default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updateSummaries/default
 * ```
 */
public class UpdateSummary internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.UpdateSummary,
) : KotlinCustomResource(javaResource, UpdateSummaryMapper) {
    /**
     * Current Solution Bundle version of the stamp.
     */
    public val currentVersion: Output<String>?
        get() = javaResource.currentVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the hardware model.
     */
    public val hardwareModel: Output<String>?
        get() = javaResource.hardwareModel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Last time the package-specific checks were run.
     */
    public val healthCheckDate: Output<String>?
        get() = javaResource.healthCheckDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Last time the update service successfully checked for updates
     */
    public val lastChecked: Output<String>?
        get() = javaResource.lastChecked().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Last time an update installation completed successfully.
     */
    public val lastUpdated: Output<String>?
        get() = javaResource.lastUpdated().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * OEM family name.
     */
    public val oemFamily: Output<String>?
        get() = javaResource.oemFamily().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Provisioning state of the UpdateSummaries proxy resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Overall update state of the stamp.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object UpdateSummaryMapper : ResourceMapper<UpdateSummary> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.UpdateSummary::class == javaResource::class

    override fun map(javaResource: Resource): UpdateSummary = UpdateSummary(
        javaResource as
            com.pulumi.azurenative.azurestackhci.UpdateSummary,
    )
}

/**
 * @see [UpdateSummary].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UpdateSummary].
 */
public suspend fun updateSummary(
    name: String,
    block: suspend UpdateSummaryResourceBuilder.() -> Unit,
): UpdateSummary {
    val builder = UpdateSummaryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UpdateSummary].
 * @param name The _unique_ name of the resulting resource.
 */
public fun updateSummary(name: String): UpdateSummary {
    val builder = UpdateSummaryResourceBuilder()
    builder.name(name)
    return builder.build()
}
