@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.UpdateSummaryArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.UpdateSummariesPropertiesState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Get the update summaries for the cluster
 * Azure REST API version: 2023-03-01.
 * Other available API versions: 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview, 2024-01-01, 2024-02-15-preview.
 * ## Example Usage
 * ### Put Update summaries under cluster resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var updateSummary = new AzureNative.AzureStackHCI.UpdateSummary("updateSummary", new()
 *     {
 *         ClusterName = "testcluster",
 *         CurrentVersion = "4.2203.2.32",
 *         HardwareModel = "PowerEdge R730xd",
 *         LastChecked = "2022-04-07T18:04:07Z",
 *         LastUpdated = "2022-04-06T14:08:18.254Z",
 *         OemFamily = "DellEMC",
 *         ResourceGroupName = "testrg",
 *         State = AzureNative.AzureStackHCI.UpdateSummariesPropertiesState.AppliedSuccessfully,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewUpdateSummary(ctx, "updateSummary", &azurestackhci.UpdateSummaryArgs{
 * 			ClusterName:       pulumi.String("testcluster"),
 * 			CurrentVersion:    pulumi.String("4.2203.2.32"),
 * 			HardwareModel:     pulumi.String("PowerEdge R730xd"),
 * 			LastChecked:       pulumi.String("2022-04-07T18:04:07Z"),
 * 			LastUpdated:       pulumi.String("2022-04-06T14:08:18.254Z"),
 * 			OemFamily:         pulumi.String("DellEMC"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			State:             pulumi.String(azurestackhci.UpdateSummariesPropertiesStateAppliedSuccessfully),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.UpdateSummary;
 * import com.pulumi.azurenative.azurestackhci.UpdateSummaryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var updateSummary = new UpdateSummary("updateSummary", UpdateSummaryArgs.builder()
 *             .clusterName("testcluster")
 *             .currentVersion("4.2203.2.32")
 *             .hardwareModel("PowerEdge R730xd")
 *             .lastChecked("2022-04-07T18:04:07Z")
 *             .lastUpdated("2022-04-06T14:08:18.254Z")
 *             .oemFamily("DellEMC")
 *             .resourceGroupName("testrg")
 *             .state("AppliedSuccessfully")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:UpdateSummary default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updateSummaries/default
 * ```
 * @property clusterName The name of the cluster.
 * @property currentVersion Current Solution Bundle version of the stamp.
 * @property hardwareModel Name of the hardware model.
 * @property healthCheckDate Last time the package-specific checks were run.
 * @property lastChecked Last time the update service successfully checked for updates
 * @property lastUpdated Last time an update installation completed successfully.
 * @property location The geo-location where the resource lives
 * @property oemFamily OEM family name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property state Overall update state of the stamp.
 */
public data class UpdateSummaryArgs(
    public val clusterName: Output<String>? = null,
    public val currentVersion: Output<String>? = null,
    public val hardwareModel: Output<String>? = null,
    public val healthCheckDate: Output<String>? = null,
    public val lastChecked: Output<String>? = null,
    public val lastUpdated: Output<String>? = null,
    public val location: Output<String>? = null,
    public val oemFamily: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val state: Output<Either<String, UpdateSummariesPropertiesState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.UpdateSummaryArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.UpdateSummaryArgs =
        com.pulumi.azurenative.azurestackhci.UpdateSummaryArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .currentVersion(currentVersion?.applyValue({ args0 -> args0 }))
            .hardwareModel(hardwareModel?.applyValue({ args0 -> args0 }))
            .healthCheckDate(healthCheckDate?.applyValue({ args0 -> args0 }))
            .lastChecked(lastChecked?.applyValue({ args0 -> args0 }))
            .lastUpdated(lastUpdated?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .oemFamily(oemFamily?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [UpdateSummaryArgs].
 */
@PulumiTagMarker
public class UpdateSummaryArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var currentVersion: Output<String>? = null

    private var hardwareModel: Output<String>? = null

    private var healthCheckDate: Output<String>? = null

    private var lastChecked: Output<String>? = null

    private var lastUpdated: Output<String>? = null

    private var location: Output<String>? = null

    private var oemFamily: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var state: Output<Either<String, UpdateSummariesPropertiesState>>? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("vfcytlmcangosdcd")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Current Solution Bundle version of the stamp.
     */
    @JvmName("yglkwuyrwninvhmb")
    public suspend fun currentVersion(`value`: Output<String>) {
        this.currentVersion = value
    }

    /**
     * @param value Name of the hardware model.
     */
    @JvmName("wbgejofebfidojeb")
    public suspend fun hardwareModel(`value`: Output<String>) {
        this.hardwareModel = value
    }

    /**
     * @param value Last time the package-specific checks were run.
     */
    @JvmName("ukkjixgyfhiakaqr")
    public suspend fun healthCheckDate(`value`: Output<String>) {
        this.healthCheckDate = value
    }

    /**
     * @param value Last time the update service successfully checked for updates
     */
    @JvmName("iaqwxcllshetrpag")
    public suspend fun lastChecked(`value`: Output<String>) {
        this.lastChecked = value
    }

    /**
     * @param value Last time an update installation completed successfully.
     */
    @JvmName("mgpsfutvgjtnfhpu")
    public suspend fun lastUpdated(`value`: Output<String>) {
        this.lastUpdated = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rsianimoghtxlqxj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value OEM family name.
     */
    @JvmName("spaevruelwkeeqsr")
    public suspend fun oemFamily(`value`: Output<String>) {
        this.oemFamily = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nioxfyutqukwtcvl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Overall update state of the stamp.
     */
    @JvmName("rneiywqkivisurqr")
    public suspend fun state(`value`: Output<Either<String, UpdateSummariesPropertiesState>>) {
        this.state = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("ongqyynhghqjucwb")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Current Solution Bundle version of the stamp.
     */
    @JvmName("bjbgirqqkbucaaqg")
    public suspend fun currentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currentVersion = mapped
    }

    /**
     * @param value Name of the hardware model.
     */
    @JvmName("nipwlofpxgexgocp")
    public suspend fun hardwareModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareModel = mapped
    }

    /**
     * @param value Last time the package-specific checks were run.
     */
    @JvmName("bqpvyrbefnunfkup")
    public suspend fun healthCheckDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckDate = mapped
    }

    /**
     * @param value Last time the update service successfully checked for updates
     */
    @JvmName("hjebykwplmmigobk")
    public suspend fun lastChecked(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastChecked = mapped
    }

    /**
     * @param value Last time an update installation completed successfully.
     */
    @JvmName("ivslkgypcutnkftr")
    public suspend fun lastUpdated(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdated = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("aqaswkukycktexec")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value OEM family name.
     */
    @JvmName("niokirrhmiqaxbly")
    public suspend fun oemFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oemFamily = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("njbqqumyypisluje")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Overall update state of the stamp.
     */
    @JvmName("qrcfnwdbtvfqsyvu")
    public suspend fun state(`value`: Either<String, UpdateSummariesPropertiesState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Overall update state of the stamp.
     */
    @JvmName("wqmrwcvfiohktoyg")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UpdateSummariesPropertiesState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Overall update state of the stamp.
     */
    @JvmName("ginpdcfobkfbbwaq")
    public fun state(`value`: UpdateSummariesPropertiesState) {
        val toBeMapped = Either.ofRight<String, UpdateSummariesPropertiesState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): UpdateSummaryArgs = UpdateSummaryArgs(
        clusterName = clusterName,
        currentVersion = currentVersion,
        hardwareModel = hardwareModel,
        healthCheckDate = healthCheckDate,
        lastChecked = lastChecked,
        lastUpdated = lastUpdated,
        location = location,
        oemFamily = oemFamily,
        resourceGroupName = resourceGroupName,
        state = state,
    )
}
