@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.VirtualHardDiskArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.DiskFileFormat
import com.pulumi.azurenative.azurestackhci.kotlin.enums.HyperVGeneration
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The virtual hard disk resource definition.
 * Azure REST API version: 2022-12-15-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2024-01-01.
 * ## Example Usage
 * ### PutVirtualHardDisk
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualHardDisk = new AzureNative.AzureStackHCI.VirtualHardDisk("virtualHardDisk", new()
 *     {
 *         DiskSizeGB = 32,
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         Location = "West US2",
 *         ResourceGroupName = "test-rg",
 *         VirtualHardDiskName = "test-vhd",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualHardDisk(ctx, "virtualHardDisk", &azurestackhci.VirtualHardDiskArgs{
 * 			DiskSizeGB: pulumi.Float64(32),
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			Location:            pulumi.String("West US2"),
 * 			ResourceGroupName:   pulumi.String("test-rg"),
 * 			VirtualHardDiskName: pulumi.String("test-vhd"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualHardDisk;
 * import com.pulumi.azurenative.azurestackhci.VirtualHardDiskArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualHardDisk = new VirtualHardDisk("virtualHardDisk", VirtualHardDiskArgs.builder()
 *             .diskSizeGB(32)
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("West US2")
 *             .resourceGroupName("test-rg")
 *             .virtualHardDiskName("test-vhd")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:VirtualHardDisk test-vhd /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualHardDisks/{virtualHardDiskName}
 * ```
 * @property blockSizeBytes
 * @property containerId Storage ContainerID of the storage container to be used for VHD
 * @property diskFileFormat The format of the actual VHD file [vhd, vhdx]
 * @property diskSizeGB Size of the disk in GB
 * @property dynamic Boolean for enabling dynamic sizing on the virtual hard disk
 * @property extendedLocation The extendedLocation of the resource.
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine [V1, V2]
 * @property location The geo-location where the resource lives
 * @property logicalSectorBytes
 * @property physicalSectorBytes
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property virtualHardDiskName Name of the virtual hard disk
 */
public data class VirtualHardDiskArgs(
    public val blockSizeBytes: Output<Int>? = null,
    public val containerId: Output<String>? = null,
    public val diskFileFormat: Output<Either<String, DiskFileFormat>>? = null,
    public val diskSizeGB: Output<Double>? = null,
    public val `dynamic`: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null,
    public val location: Output<String>? = null,
    public val logicalSectorBytes: Output<Int>? = null,
    public val physicalSectorBytes: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualHardDiskName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.VirtualHardDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.VirtualHardDiskArgs =
        com.pulumi.azurenative.azurestackhci.VirtualHardDiskArgs.builder()
            .blockSizeBytes(blockSizeBytes?.applyValue({ args0 -> args0 }))
            .containerId(containerId?.applyValue({ args0 -> args0 }))
            .diskFileFormat(
                diskFileFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .`dynamic`(`dynamic`?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hyperVGeneration(
                hyperVGeneration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .logicalSectorBytes(logicalSectorBytes?.applyValue({ args0 -> args0 }))
            .physicalSectorBytes(physicalSectorBytes?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualHardDiskName(virtualHardDiskName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualHardDiskArgs].
 */
@PulumiTagMarker
public class VirtualHardDiskArgsBuilder internal constructor() {
    private var blockSizeBytes: Output<Int>? = null

    private var containerId: Output<String>? = null

    private var diskFileFormat: Output<Either<String, DiskFileFormat>>? = null

    private var diskSizeGB: Output<Double>? = null

    private var `dynamic`: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null

    private var location: Output<String>? = null

    private var logicalSectorBytes: Output<Int>? = null

    private var physicalSectorBytes: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualHardDiskName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("sonsdohkfckatptl")
    public suspend fun blockSizeBytes(`value`: Output<Int>) {
        this.blockSizeBytes = value
    }

    /**
     * @param value Storage ContainerID of the storage container to be used for VHD
     */
    @JvmName("xieiayxxdvtoxeou")
    public suspend fun containerId(`value`: Output<String>) {
        this.containerId = value
    }

    /**
     * @param value The format of the actual VHD file [vhd, vhdx]
     */
    @JvmName("uhjbonxcmgryulht")
    public suspend fun diskFileFormat(`value`: Output<Either<String, DiskFileFormat>>) {
        this.diskFileFormat = value
    }

    /**
     * @param value Size of the disk in GB
     */
    @JvmName("rxbwrtvjcihrseqg")
    public suspend fun diskSizeGB(`value`: Output<Double>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Boolean for enabling dynamic sizing on the virtual hard disk
     */
    @JvmName("ptjqelcsrqkniddb")
    public suspend fun `dynamic`(`value`: Output<Boolean>) {
        this.`dynamic` = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("ohnnvalpiebanfqy")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine [V1, V2]
     */
    @JvmName("ptlnmqsldiclqlxu")
    public suspend fun hyperVGeneration(`value`: Output<Either<String, HyperVGeneration>>) {
        this.hyperVGeneration = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dbftseienrxsuhgu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value
     */
    @JvmName("vgspykonvvlybqhm")
    public suspend fun logicalSectorBytes(`value`: Output<Int>) {
        this.logicalSectorBytes = value
    }

    /**
     * @param value
     */
    @JvmName("xgmggemfauteowuo")
    public suspend fun physicalSectorBytes(`value`: Output<Int>) {
        this.physicalSectorBytes = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("arerwdcfjnxkmgnf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fivxftrrhksppmir")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the virtual hard disk
     */
    @JvmName("taeusqoroimfwcds")
    public suspend fun virtualHardDiskName(`value`: Output<String>) {
        this.virtualHardDiskName = value
    }

    /**
     * @param value
     */
    @JvmName("frgaukvmvkksxswd")
    public suspend fun blockSizeBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockSizeBytes = mapped
    }

    /**
     * @param value Storage ContainerID of the storage container to be used for VHD
     */
    @JvmName("plsfwdykrsialqyh")
    public suspend fun containerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerId = mapped
    }

    /**
     * @param value The format of the actual VHD file [vhd, vhdx]
     */
    @JvmName("fsbdqhotvjprurlf")
    public suspend fun diskFileFormat(`value`: Either<String, DiskFileFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskFileFormat = mapped
    }

    /**
     * @param value The format of the actual VHD file [vhd, vhdx]
     */
    @JvmName("qetpnrebfjsbnyyt")
    public fun diskFileFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskFileFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskFileFormat = mapped
    }

    /**
     * @param value The format of the actual VHD file [vhd, vhdx]
     */
    @JvmName("nsllhwkijxvbmhno")
    public fun diskFileFormat(`value`: DiskFileFormat) {
        val toBeMapped = Either.ofRight<String, DiskFileFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskFileFormat = mapped
    }

    /**
     * @param value Size of the disk in GB
     */
    @JvmName("nhmvbrujxblyjcdl")
    public suspend fun diskSizeGB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Boolean for enabling dynamic sizing on the virtual hard disk
     */
    @JvmName("njrtpxrtbsiahkon")
    public suspend fun `dynamic`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`dynamic` = mapped
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("xjhmoqvhdfpdnury")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("vlusaomxnvptsysg")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine [V1, V2]
     */
    @JvmName("yofefyqnoyvulqsm")
    public suspend fun hyperVGeneration(`value`: Either<String, HyperVGeneration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine [V1, V2]
     */
    @JvmName("ocgtbpwafnwslibs")
    public fun hyperVGeneration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine [V1, V2]
     */
    @JvmName("puddqwyskbfarhin")
    public fun hyperVGeneration(`value`: HyperVGeneration) {
        val toBeMapped = Either.ofRight<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fipeegxujufjeobi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value
     */
    @JvmName("xippnjdyytodohjo")
    public suspend fun logicalSectorBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicalSectorBytes = mapped
    }

    /**
     * @param value
     */
    @JvmName("mujtldyymtwacqsl")
    public suspend fun physicalSectorBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.physicalSectorBytes = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gxkwbbvshfspinlv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gujblrmdcdwvxgib")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("aatarksvcsxwkaxt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the virtual hard disk
     */
    @JvmName("awquynyqlrxbynbp")
    public suspend fun virtualHardDiskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHardDiskName = mapped
    }

    internal fun build(): VirtualHardDiskArgs = VirtualHardDiskArgs(
        blockSizeBytes = blockSizeBytes,
        containerId = containerId,
        diskFileFormat = diskFileFormat,
        diskSizeGB = diskSizeGB,
        `dynamic` = `dynamic`,
        extendedLocation = extendedLocation,
        hyperVGeneration = hyperVGeneration,
        location = location,
        logicalSectorBytes = logicalSectorBytes,
        physicalSectorBytes = physicalSectorBytes,
        resourceGroupName = resourceGroupName,
        tags = tags,
        virtualHardDiskName = virtualHardDiskName,
    )
}
