@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GuestAgentProfileResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseHardwareProfile
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseNetworkProfile
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseOsProfile
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseSecurityProfile
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseStorageProfile
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineStatusResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GuestAgentProfileResponse.Companion.toKotlin as guestAgentProfileResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseHardwareProfile.Companion.toKotlin as virtualMachinePropertiesResponseHardwareProfileToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseNetworkProfile.Companion.toKotlin as virtualMachinePropertiesResponseNetworkProfileToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseOsProfile.Companion.toKotlin as virtualMachinePropertiesResponseOsProfileToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseSecurityProfile.Companion.toKotlin as virtualMachinePropertiesResponseSecurityProfileToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachinePropertiesResponseStorageProfile.Companion.toKotlin as virtualMachinePropertiesResponseStorageProfileToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualMachineStatusResponse.Companion.toKotlin as virtualMachineStatusResponseToKotlin

/**
 * Builder for [VirtualMachine].
 */
@PulumiTagMarker
public class VirtualMachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineArgs = VirtualMachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineArgsBuilder.() -> Unit) {
        val builder = VirtualMachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachine {
        val builtJavaResource =
            com.pulumi.azurenative.azurestackhci.VirtualMachine(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachine(builtJavaResource)
    }
}

/**
 * The virtual machine resource definition.
 * Azure REST API version: 2022-12-15-preview.
 * ## Example Usage
 * ### PutVirtualMachineWithGalleryImage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.AzureStackHCI.VirtualMachine("virtualMachine", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesHardwareProfileArgs
 *         {
 *             VmSize = AzureNative.AzureStackHCI.VmSizeEnum.Default,
 *         },
 *         Location = "West US2",
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesOsProfileArgs
 *         {
 *             AdminPassword = "password",
 *             AdminUsername = "localadmin",
 *             ComputerName = "luamaster",
 *         },
 *         ResourceGroupName = "test-rg",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesStorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *         VirtualMachineName = "test-vm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachine(ctx, "virtualMachine", &azurestackhci.VirtualMachineArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachinePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String(azurestackhci.VmSizeEnumDefault),
 * 			},
 * 			Location: pulumi.String("West US2"),
 * 			NetworkProfile: &azurestackhci.VirtualMachinePropertiesNetworkProfileArgs{
 * 				NetworkInterfaces: azurestackhci.VirtualMachinePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachinePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &azurestackhci.VirtualMachinePropertiesOsProfileArgs{
 * 				AdminPassword: pulumi.String("password"),
 * 				AdminUsername: pulumi.String("localadmin"),
 * 				ComputerName:  pulumi.String("luamaster"),
 * 			},
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SecurityProfile: &azurestackhci.VirtualMachinePropertiesSecurityProfileArgs{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachinePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &azurestackhci.VirtualMachinePropertiesStorageProfileArgs{
 * 				ImageReference: &azurestackhci.VirtualMachinePropertiesImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 			VirtualMachineName: pulumi.String("test-vm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachine;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesHardwareProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesNetworkProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesOsProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSecurityProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesUefiSettingsArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesStorageProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesImageReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .hardwareProfile(VirtualMachinePropertiesHardwareProfileArgs.builder()
 *                 .vmSize("Default")
 *                 .build())
 *             .location("West US2")
 *             .networkProfile(VirtualMachinePropertiesNetworkProfileArgs.builder()
 *                 .networkInterfaces(VirtualMachinePropertiesNetworkInterfacesArgs.builder()
 *                     .id("test-nic")
 *                     .build())
 *                 .build())
 *             .osProfile(VirtualMachinePropertiesOsProfileArgs.builder()
 *                 .adminPassword("password")
 *                 .adminUsername("localadmin")
 *                 .computerName("luamaster")
 *                 .build())
 *             .resourceGroupName("test-rg")
 *             .securityProfile(VirtualMachinePropertiesSecurityProfileArgs.builder()
 *                 .enableTPM(true)
 *                 .uefiSettings(VirtualMachinePropertiesUefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(VirtualMachinePropertiesStorageProfileArgs.builder()
 *                 .imageReference(VirtualMachinePropertiesImageReferenceArgs.builder()
 *                     .id("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/galleryImages/test-gallery-image")
 *                     .build())
 *                 .vmConfigStoragePathId("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *                 .build())
 *             .virtualMachineName("test-vm")
 *             .build());
 *     }
 * }
 * ```
 * ### PutVirtualMachineWithMarketplaceGalleryImage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.AzureStackHCI.VirtualMachine("virtualMachine", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesHardwareProfileArgs
 *         {
 *             VmSize = AzureNative.AzureStackHCI.VmSizeEnum.Default,
 *         },
 *         Location = "West US2",
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesOsProfileArgs
 *         {
 *             AdminPassword = "password",
 *             AdminUsername = "localadmin",
 *             ComputerName = "luamaster",
 *         },
 *         ResourceGroupName = "test-rg",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesStorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *         VirtualMachineName = "test-vm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachine(ctx, "virtualMachine", &azurestackhci.VirtualMachineArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachinePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String(azurestackhci.VmSizeEnumDefault),
 * 			},
 * 			Location: pulumi.String("West US2"),
 * 			NetworkProfile: &azurestackhci.VirtualMachinePropertiesNetworkProfileArgs{
 * 				NetworkInterfaces: azurestackhci.VirtualMachinePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachinePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &azurestackhci.VirtualMachinePropertiesOsProfileArgs{
 * 				AdminPassword: pulumi.String("password"),
 * 				AdminUsername: pulumi.String("localadmin"),
 * 				ComputerName:  pulumi.String("luamaster"),
 * 			},
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SecurityProfile: &azurestackhci.VirtualMachinePropertiesSecurityProfileArgs{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachinePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &azurestackhci.VirtualMachinePropertiesStorageProfileArgs{
 * 				ImageReference: &azurestackhci.VirtualMachinePropertiesImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 			VirtualMachineName: pulumi.String("test-vm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachine;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesHardwareProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesNetworkProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesOsProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSecurityProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesUefiSettingsArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesStorageProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesImageReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .hardwareProfile(VirtualMachinePropertiesHardwareProfileArgs.builder()
 *                 .vmSize("Default")
 *                 .build())
 *             .location("West US2")
 *             .networkProfile(VirtualMachinePropertiesNetworkProfileArgs.builder()
 *                 .networkInterfaces(VirtualMachinePropertiesNetworkInterfacesArgs.builder()
 *                     .id("test-nic")
 *                     .build())
 *                 .build())
 *             .osProfile(VirtualMachinePropertiesOsProfileArgs.builder()
 *                 .adminPassword("password")
 *                 .adminUsername("localadmin")
 *                 .computerName("luamaster")
 *                 .build())
 *             .resourceGroupName("test-rg")
 *             .securityProfile(VirtualMachinePropertiesSecurityProfileArgs.builder()
 *                 .enableTPM(true)
 *                 .uefiSettings(VirtualMachinePropertiesUefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(VirtualMachinePropertiesStorageProfileArgs.builder()
 *                 .imageReference(VirtualMachinePropertiesImageReferenceArgs.builder()
 *                     .id("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/test-marketplace-gallery-image")
 *                     .build())
 *                 .vmConfigStoragePathId("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *                 .build())
 *             .virtualMachineName("test-vm")
 *             .build());
 *     }
 * }
 * ```
 * ### PutVirtualMachineWithOsDisk
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.AzureStackHCI.VirtualMachine("virtualMachine", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         HardwareProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesHardwareProfileArgs
 *         {
 *             VmSize = AzureNative.AzureStackHCI.VmSizeEnum.Default,
 *         },
 *         Location = "West US2",
 *         NetworkProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesNetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesNetworkInterfacesArgs
 *                 {
 *                     Id = "test-nic",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *         SecurityProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesSecurityProfileArgs
 *         {
 *             EnableTPM = true,
 *             UefiSettings = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesUefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.AzureStackHCI.Inputs.VirtualMachinePropertiesOsDiskArgs
 *             {
 *                 Id = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd",
 *             },
 *             VmConfigStoragePathId = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container",
 *         },
 *         VirtualMachineName = "test-vm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualMachine(ctx, "virtualMachine", &azurestackhci.VirtualMachineArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			HardwareProfile: &azurestackhci.VirtualMachinePropertiesHardwareProfileArgs{
 * 				VmSize: pulumi.String(azurestackhci.VmSizeEnumDefault),
 * 			},
 * 			Location: pulumi.String("West US2"),
 * 			NetworkProfile: &azurestackhci.VirtualMachinePropertiesNetworkProfileArgs{
 * 				NetworkInterfaces: azurestackhci.VirtualMachinePropertiesNetworkInterfacesArray{
 * 					&azurestackhci.VirtualMachinePropertiesNetworkInterfacesArgs{
 * 						Id: pulumi.String("test-nic"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SecurityProfile: &azurestackhci.VirtualMachinePropertiesSecurityProfileArgs{
 * 				EnableTPM: pulumi.Bool(true),
 * 				UefiSettings: &azurestackhci.VirtualMachinePropertiesUefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &azurestackhci.VirtualMachinePropertiesStorageProfileArgs{
 * 				OsDisk: &azurestackhci.VirtualMachinePropertiesOsDiskArgs{
 * 					Id: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd"),
 * 				},
 * 				VmConfigStoragePathId: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container"),
 * 			},
 * 			VirtualMachineName: pulumi.String("test-vm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachine;
 * import com.pulumi.azurenative.azurestackhci.VirtualMachineArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesHardwareProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesNetworkProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSecurityProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesUefiSettingsArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesStorageProfileArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesOsDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .hardwareProfile(VirtualMachinePropertiesHardwareProfileArgs.builder()
 *                 .vmSize("Default")
 *                 .build())
 *             .location("West US2")
 *             .networkProfile(VirtualMachinePropertiesNetworkProfileArgs.builder()
 *                 .networkInterfaces(VirtualMachinePropertiesNetworkInterfacesArgs.builder()
 *                     .id("test-nic")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("test-rg")
 *             .securityProfile(VirtualMachinePropertiesSecurityProfileArgs.builder()
 *                 .enableTPM(true)
 *                 .uefiSettings(VirtualMachinePropertiesUefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(VirtualMachinePropertiesStorageProfileArgs.builder()
 *                 .osDisk(VirtualMachinePropertiesOsDiskArgs.builder()
 *                     .id("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/virtualHardDisks/test-vhd")
 *                     .build())
 *                 .vmConfigStoragePathId("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.AzureStackHCI/storageContainers/test-container")
 *                 .build())
 *             .virtualMachineName("test-vm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:VirtualMachine myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualMachines/{virtualMachineName}
 * ```
 */
public class VirtualMachine internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.VirtualMachine,
) : KotlinCustomResource(javaResource, VirtualMachineMapper) {
    /**
     * The extendedLocation of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Guest agent status properties.
     */
    public val guestAgentProfile: Output<GuestAgentProfileResponse>?
        get() = javaResource.guestAgentProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> guestAgentProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * HardwareProfile - Specifies the hardware settings for the virtual machine.
     */
    public val hardwareProfile: Output<VirtualMachinePropertiesResponseHardwareProfile>?
        get() = javaResource.hardwareProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachinePropertiesResponseHardwareProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * NetworkProfile - describes the network configuration the virtual machine
     */
    public val networkProfile: Output<VirtualMachinePropertiesResponseNetworkProfile>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachinePropertiesResponseNetworkProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * OsProfile - describes the configuration of the operating system and sets login data
     */
    public val osProfile: Output<VirtualMachinePropertiesResponseOsProfile>?
        get() = javaResource.osProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachinePropertiesResponseOsProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Provisioning state of the virtual machine.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * SecurityProfile - Specifies the security settings for the virtual machine.
     */
    public val securityProfile: Output<VirtualMachinePropertiesResponseSecurityProfile>?
        get() = javaResource.securityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachinePropertiesResponseSecurityProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The observed state of virtual machines
     */
    public val status: Output<VirtualMachineStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualMachineStatusResponseToKotlin(args0)
            })
        })

    /**
     * StorageProfile - contains information about the disks and storage information for the virtual machine
     */
    public val storageProfile: Output<VirtualMachinePropertiesResponseStorageProfile>?
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachinePropertiesResponseStorageProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for the vm resource.
     */
    public val vmId: Output<String>
        get() = javaResource.vmId().applyValue({ args0 -> args0 })
}

public object VirtualMachineMapper : ResourceMapper<VirtualMachine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.VirtualMachine::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachine = VirtualMachine(
        javaResource as
            com.pulumi.azurenative.azurestackhci.VirtualMachine,
    )
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachine].
 */
public suspend fun virtualMachine(
    name: String,
    block: suspend VirtualMachineResourceBuilder.() -> Unit,
): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachine(name: String): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
