@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.VirtualNetworkArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.NetworkTypeEnum
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualNetworkPropertiesDhcpOptionsArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualNetworkPropertiesDhcpOptionsArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualNetworkPropertiesSubnetsArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.VirtualNetworkPropertiesSubnetsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The virtual network resource definition.
 * Azure REST API version: 2022-12-15-preview.
 * Other available API versions: 2023-07-01-preview.
 * ## Example Usage
 * ### PutVirtualNetwork
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.AzureStackHCI.VirtualNetwork("virtualNetwork", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = AzureNative.AzureStackHCI.ExtendedLocationTypes.CustomLocation,
 *         },
 *         Location = "West US2",
 *         NetworkType = AzureNative.AzureStackHCI.NetworkTypeEnum.Transparent,
 *         ResourceGroupName = "test-rg",
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualNetwork(ctx, "virtualNetwork", &azurestackhci.VirtualNetworkArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String(azurestackhci.ExtendedLocationTypesCustomLocation),
 * 			},
 * 			Location:           pulumi.String("West US2"),
 * 			NetworkType:        pulumi.String(azurestackhci.NetworkTypeEnumTransparent),
 * 			ResourceGroupName:  pulumi.String("test-rg"),
 * 			VirtualNetworkName: pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualNetwork;
 * import com.pulumi.azurenative.azurestackhci.VirtualNetworkArgs;
 * import com.pulumi.azurenative.azurestackhci.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("West US2")
 *             .networkType("Transparent")
 *             .resourceGroupName("test-rg")
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:VirtualNetwork test-vnet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualNetworks/{virtualNetworkName}
 * ```
 * @property dhcpOptions DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
 * @property extendedLocation The extendedLocation of the resource.
 * @property location The geo-location where the resource lives
 * @property networkType Type of the network
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subnets Subnet - list of subnets under the virtual network
 * @property tags Resource tags.
 * @property virtualNetworkName Name of the virtual network
 * @property vmSwitchName name of the network switch to be used for VMs
 */
public data class VirtualNetworkArgs(
    public val dhcpOptions: Output<VirtualNetworkPropertiesDhcpOptionsArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val networkType: Output<Either<String, NetworkTypeEnum>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnets: Output<List<VirtualNetworkPropertiesSubnetsArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualNetworkName: Output<String>? = null,
    public val vmSwitchName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.VirtualNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.VirtualNetworkArgs =
        com.pulumi.azurenative.azurestackhci.VirtualNetworkArgs.builder()
            .dhcpOptions(dhcpOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkType(
                networkType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnets(
                subnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualNetworkName(virtualNetworkName?.applyValue({ args0 -> args0 }))
            .vmSwitchName(vmSwitchName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkArgs].
 */
@PulumiTagMarker
public class VirtualNetworkArgsBuilder internal constructor() {
    private var dhcpOptions: Output<VirtualNetworkPropertiesDhcpOptionsArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var networkType: Output<Either<String, NetworkTypeEnum>>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnets: Output<List<VirtualNetworkPropertiesSubnetsArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualNetworkName: Output<String>? = null

    private var vmSwitchName: Output<String>? = null

    /**
     * @param value DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
     */
    @JvmName("hfrgojhpkytjqeuq")
    public suspend fun dhcpOptions(`value`: Output<VirtualNetworkPropertiesDhcpOptionsArgs>) {
        this.dhcpOptions = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("usuuriljoisbyfta")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("orrjsvmvhsflforu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Type of the network
     */
    @JvmName("iumdylqqhfyxpvad")
    public suspend fun networkType(`value`: Output<Either<String, NetworkTypeEnum>>) {
        this.networkType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fyxjhahjdqwibcjs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Subnet - list of subnets under the virtual network
     */
    @JvmName("btqywtihksifufbq")
    public suspend fun subnets(`value`: Output<List<VirtualNetworkPropertiesSubnetsArgs>>) {
        this.subnets = value
    }

    @JvmName("fmnumgfkqtkwybto")
    public suspend fun subnets(vararg values: Output<VirtualNetworkPropertiesSubnetsArgs>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values Subnet - list of subnets under the virtual network
     */
    @JvmName("julfncgrdihvrkqa")
    public suspend fun subnets(values: List<Output<VirtualNetworkPropertiesSubnetsArgs>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("swrrbwoafpxwndti")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the virtual network
     */
    @JvmName("llxybrlvllwehfnk")
    public suspend fun virtualNetworkName(`value`: Output<String>) {
        this.virtualNetworkName = value
    }

    /**
     * @param value name of the network switch to be used for VMs
     */
    @JvmName("jusdynoyhphnhnch")
    public suspend fun vmSwitchName(`value`: Output<String>) {
        this.vmSwitchName = value
    }

    /**
     * @param value DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
     */
    @JvmName("asrpqwaxdmvyfihl")
    public suspend fun dhcpOptions(`value`: VirtualNetworkPropertiesDhcpOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dhcpOptions = mapped
    }

    /**
     * @param argument DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
     */
    @JvmName("eeysnbjsisnewead")
    public suspend
    fun dhcpOptions(argument: suspend VirtualNetworkPropertiesDhcpOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkPropertiesDhcpOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dhcpOptions = mapped
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("kgxjllifwolguouk")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("rveftapeyclgvxhf")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xcewjusxvbfrklqc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Type of the network
     */
    @JvmName("kplhfcvpqkhciccj")
    public suspend fun networkType(`value`: Either<String, NetworkTypeEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value Type of the network
     */
    @JvmName("dvaaqyunymjentbw")
    public fun networkType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value Type of the network
     */
    @JvmName("arqypsxwlrkepplu")
    public fun networkType(`value`: NetworkTypeEnum) {
        val toBeMapped = Either.ofRight<String, NetworkTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eqiyqjgxqjnnbtgx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Subnet - list of subnets under the virtual network
     */
    @JvmName("sigcxnccrididopk")
    public suspend fun subnets(`value`: List<VirtualNetworkPropertiesSubnetsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param argument Subnet - list of subnets under the virtual network
     */
    @JvmName("bobcebamvmrpcoin")
    public suspend
    fun subnets(argument: List<suspend VirtualNetworkPropertiesSubnetsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkPropertiesSubnetsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument Subnet - list of subnets under the virtual network
     */
    @JvmName("ufrdtoljbbwklmku")
    public suspend fun subnets(
        vararg
        argument: suspend VirtualNetworkPropertiesSubnetsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkPropertiesSubnetsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument Subnet - list of subnets under the virtual network
     */
    @JvmName("etintjtwomatqxoc")
    public suspend
    fun subnets(argument: suspend VirtualNetworkPropertiesSubnetsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNetworkPropertiesSubnetsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param values Subnet - list of subnets under the virtual network
     */
    @JvmName("yddavbsxfukcmnsv")
    public suspend fun subnets(vararg values: VirtualNetworkPropertiesSubnetsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("txrnnplonmybrdke")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("srqgugsbxowewmjr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the virtual network
     */
    @JvmName("pigttbhmimiilgra")
    public suspend fun virtualNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkName = mapped
    }

    /**
     * @param value name of the network switch to be used for VMs
     */
    @JvmName("cufjtstwvmegjvtk")
    public suspend fun vmSwitchName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSwitchName = mapped
    }

    internal fun build(): VirtualNetworkArgs = VirtualNetworkArgs(
        dhcpOptions = dhcpOptions,
        extendedLocation = extendedLocation,
        location = location,
        networkType = networkType,
        resourceGroupName = resourceGroupName,
        subnets = subnets,
        tags = tags,
        virtualNetworkName = virtualNetworkName,
        vmSwitchName = vmSwitchName,
    )
}
