@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * State of the update as it relates to this stamp.
 */
public enum class State(
    public val javaValue: com.pulumi.azurenative.azurestackhci.enums.State,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.enums.State> {
    HasPrerequisite(com.pulumi.azurenative.azurestackhci.enums.State.HasPrerequisite),
    Obsolete(com.pulumi.azurenative.azurestackhci.enums.State.Obsolete),
    Ready(com.pulumi.azurenative.azurestackhci.enums.State.Ready),
    NotApplicableBecauseAnotherUpdateIsInProgress(com.pulumi.azurenative.azurestackhci.enums.State.NotApplicableBecauseAnotherUpdateIsInProgress),
    Preparing(com.pulumi.azurenative.azurestackhci.enums.State.Preparing),
    Installing(com.pulumi.azurenative.azurestackhci.enums.State.Installing),
    Installed(com.pulumi.azurenative.azurestackhci.enums.State.Installed),
    PreparationFailed(com.pulumi.azurenative.azurestackhci.enums.State.PreparationFailed),
    InstallationFailed(com.pulumi.azurenative.azurestackhci.enums.State.InstallationFailed),
    Invalid(com.pulumi.azurenative.azurestackhci.enums.State.Invalid),
    Recalled(com.pulumi.azurenative.azurestackhci.enums.State.Recalled),
    Downloading(com.pulumi.azurenative.azurestackhci.enums.State.Downloading),
    DownloadFailed(com.pulumi.azurenative.azurestackhci.enums.State.DownloadFailed),
    HealthChecking(com.pulumi.azurenative.azurestackhci.enums.State.HealthChecking),
    HealthCheckFailed(com.pulumi.azurenative.azurestackhci.enums.State.HealthCheckFailed),
    ReadyToInstall(com.pulumi.azurenative.azurestackhci.enums.State.ReadyToInstall),
    ScanInProgress(com.pulumi.azurenative.azurestackhci.enums.State.ScanInProgress),
    ScanFailed(com.pulumi.azurenative.azurestackhci.enums.State.ScanFailed),
    ;

    override fun toJava(): com.pulumi.azurenative.azurestackhci.enums.State = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.enums.State): State =
            State.values().first { it.javaValue == javaType }
    }
}
