@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetHybridIdentityMetadatumPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metadataName Name of the HybridIdentityMetadata.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property virtualMachineName Name of the vm.
 */
public data class GetHybridIdentityMetadatumPlainArgs(
    public val metadataName: String,
    public val resourceGroupName: String,
    public val virtualMachineName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetHybridIdentityMetadatumPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.GetHybridIdentityMetadatumPlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetHybridIdentityMetadatumPlainArgs.builder()
            .metadataName(metadataName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHybridIdentityMetadatumPlainArgs].
 */
@PulumiTagMarker
public class GetHybridIdentityMetadatumPlainArgsBuilder internal constructor() {
    private var metadataName: String? = null

    private var resourceGroupName: String? = null

    private var virtualMachineName: String? = null

    /**
     * @param value Name of the HybridIdentityMetadata.
     */
    @JvmName("tscwhjvvudmfeppv")
    public suspend fun metadataName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.metadataName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("khwhgskrpqvdixge")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("doaeccqraqhmslfm")
    public suspend fun virtualMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualMachineName = mapped
    }

    internal fun build(): GetHybridIdentityMetadatumPlainArgs = GetHybridIdentityMetadatumPlainArgs(
        metadataName = metadataName ?: throw PulumiNullFieldException("metadataName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualMachineName = virtualMachineName ?: throw PulumiNullFieldException("virtualMachineName"),
    )
}
