@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetSecuritySettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securitySettingsName Name of security setting
 */
public data class GetSecuritySettingPlainArgs(
    public val clusterName: String,
    public val resourceGroupName: String,
    public val securitySettingsName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetSecuritySettingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetSecuritySettingPlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetSecuritySettingPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securitySettingsName(securitySettingsName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecuritySettingPlainArgs].
 */
@PulumiTagMarker
public class GetSecuritySettingPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    private var securitySettingsName: String? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("lnfgrblvfexbifpn")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("enofkywsfuvmkria")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of security setting
     */
    @JvmName("ryocmjyrfdgpbbww")
    public suspend fun securitySettingsName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securitySettingsName = mapped
    }

    internal fun build(): GetSecuritySettingPlainArgs = GetSecuritySettingPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        securitySettingsName = securitySettingsName ?: throw
            PulumiNullFieldException("securitySettingsName"),
    )
}
