@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.HostNetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The HostNetwork of a cluster.
 * @property enableStorageAutoIp Optional parameter required only for 3 Nodes Switchless deployments. This allows users to specify IPs and Mask for Storage NICs when Network ATC is not assigning the IPs for storage automatically.
 * @property intents The network intents assigned to the network reference pattern used for the deployment. Each intent will define its own name, traffic type, adapter names, and overrides as recommended by your OEM.
 * @property storageConnectivitySwitchless Defines how the storage adapters between nodes are connected either switch or switch less..
 * @property storageNetworks List of StorageNetworks config to deploy AzureStackHCI Cluster.
 */
public data class HostNetworkArgs(
    public val enableStorageAutoIp: Output<Boolean>? = null,
    public val intents: Output<List<IntentsArgs>>? = null,
    public val storageConnectivitySwitchless: Output<Boolean>? = null,
    public val storageNetworks: Output<List<StorageNetworksArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.HostNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.HostNetworkArgs =
        com.pulumi.azurenative.azurestackhci.inputs.HostNetworkArgs.builder()
            .enableStorageAutoIp(enableStorageAutoIp?.applyValue({ args0 -> args0 }))
            .intents(
                intents?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageConnectivitySwitchless(storageConnectivitySwitchless?.applyValue({ args0 -> args0 }))
            .storageNetworks(
                storageNetworks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [HostNetworkArgs].
 */
@PulumiTagMarker
public class HostNetworkArgsBuilder internal constructor() {
    private var enableStorageAutoIp: Output<Boolean>? = null

    private var intents: Output<List<IntentsArgs>>? = null

    private var storageConnectivitySwitchless: Output<Boolean>? = null

    private var storageNetworks: Output<List<StorageNetworksArgs>>? = null

    /**
     * @param value Optional parameter required only for 3 Nodes Switchless deployments. This allows users to specify IPs and Mask for Storage NICs when Network ATC is not assigning the IPs for storage automatically.
     */
    @JvmName("fpltsxdchopjjild")
    public suspend fun enableStorageAutoIp(`value`: Output<Boolean>) {
        this.enableStorageAutoIp = value
    }

    /**
     * @param value The network intents assigned to the network reference pattern used for the deployment. Each intent will define its own name, traffic type, adapter names, and overrides as recommended by your OEM.
     */
    @JvmName("tksixvwrindoshlj")
    public suspend fun intents(`value`: Output<List<IntentsArgs>>) {
        this.intents = value
    }

    @JvmName("phoitajcskskfiiq")
    public suspend fun intents(vararg values: Output<IntentsArgs>) {
        this.intents = Output.all(values.asList())
    }

    /**
     * @param values The network intents assigned to the network reference pattern used for the deployment. Each intent will define its own name, traffic type, adapter names, and overrides as recommended by your OEM.
     */
    @JvmName("wxtxvpdmgveclbip")
    public suspend fun intents(values: List<Output<IntentsArgs>>) {
        this.intents = Output.all(values)
    }

    /**
     * @param value Defines how the storage adapters between nodes are connected either switch or switch less..
     */
    @JvmName("uqstfnpvecuaontb")
    public suspend fun storageConnectivitySwitchless(`value`: Output<Boolean>) {
        this.storageConnectivitySwitchless = value
    }

    /**
     * @param value List of StorageNetworks config to deploy AzureStackHCI Cluster.
     */
    @JvmName("avybdaqbrimxxtof")
    public suspend fun storageNetworks(`value`: Output<List<StorageNetworksArgs>>) {
        this.storageNetworks = value
    }

    @JvmName("whgiyelublvmokyq")
    public suspend fun storageNetworks(vararg values: Output<StorageNetworksArgs>) {
        this.storageNetworks = Output.all(values.asList())
    }

    /**
     * @param values List of StorageNetworks config to deploy AzureStackHCI Cluster.
     */
    @JvmName("tkiuehokpatpaygy")
    public suspend fun storageNetworks(values: List<Output<StorageNetworksArgs>>) {
        this.storageNetworks = Output.all(values)
    }

    /**
     * @param value Optional parameter required only for 3 Nodes Switchless deployments. This allows users to specify IPs and Mask for Storage NICs when Network ATC is not assigning the IPs for storage automatically.
     */
    @JvmName("vhouqksrfhkvkpcm")
    public suspend fun enableStorageAutoIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableStorageAutoIp = mapped
    }

    /**
     * @param value The network intents assigned to the network reference pattern used for the deployment. Each intent will define its own name, traffic type, adapter names, and overrides as recommended by your OEM.
     */
    @JvmName("cbodbiotbuptosui")
    public suspend fun intents(`value`: List<IntentsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intents = mapped
    }

    /**
     * @param argument The network intents assigned to the network reference pattern used for the deployment. Each intent will define its own name, traffic type, adapter names, and overrides as recommended by your OEM.
     */
    @JvmName("kqtlegtjguobgnte")
    public suspend fun intents(argument: List<suspend IntentsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IntentsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.intents = mapped
    }

    /**
     * @param argument The network intents assigned to the network reference pattern used for the deployment. Each intent will define its own name, traffic type, adapter names, and overrides as recommended by your OEM.
     */
    @JvmName("kppxrhfuhacryalq")
    public suspend fun intents(vararg argument: suspend IntentsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IntentsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.intents = mapped
    }

    /**
     * @param argument The network intents assigned to the network reference pattern used for the deployment. Each intent will define its own name, traffic type, adapter names, and overrides as recommended by your OEM.
     */
    @JvmName("beukguvurxsnkwsn")
    public suspend fun intents(argument: suspend IntentsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IntentsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.intents = mapped
    }

    /**
     * @param values The network intents assigned to the network reference pattern used for the deployment. Each intent will define its own name, traffic type, adapter names, and overrides as recommended by your OEM.
     */
    @JvmName("nejoxspnkslenkdd")
    public suspend fun intents(vararg values: IntentsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.intents = mapped
    }

    /**
     * @param value Defines how the storage adapters between nodes are connected either switch or switch less..
     */
    @JvmName("vasttigigqqattus")
    public suspend fun storageConnectivitySwitchless(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageConnectivitySwitchless = mapped
    }

    /**
     * @param value List of StorageNetworks config to deploy AzureStackHCI Cluster.
     */
    @JvmName("mebdytibsfvkbamh")
    public suspend fun storageNetworks(`value`: List<StorageNetworksArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageNetworks = mapped
    }

    /**
     * @param argument List of StorageNetworks config to deploy AzureStackHCI Cluster.
     */
    @JvmName("sdofivnmvohvaqwg")
    public suspend
    fun storageNetworks(argument: List<suspend StorageNetworksArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageNetworksArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageNetworks = mapped
    }

    /**
     * @param argument List of StorageNetworks config to deploy AzureStackHCI Cluster.
     */
    @JvmName("pjpqefufieblxcgs")
    public suspend fun storageNetworks(
        vararg
        argument: suspend StorageNetworksArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageNetworksArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageNetworks = mapped
    }

    /**
     * @param argument List of StorageNetworks config to deploy AzureStackHCI Cluster.
     */
    @JvmName("qumuxqyykenximri")
    public suspend fun storageNetworks(argument: suspend StorageNetworksArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StorageNetworksArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageNetworks = mapped
    }

    /**
     * @param values List of StorageNetworks config to deploy AzureStackHCI Cluster.
     */
    @JvmName("abcxfwdqhxpgndev")
    public suspend fun storageNetworks(vararg values: StorageNetworksArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageNetworks = mapped
    }

    internal fun build(): HostNetworkArgs = HostNetworkArgs(
        enableStorageAutoIp = enableStorageAutoIp,
        intents = intents,
        storageConnectivitySwitchless = storageConnectivitySwitchless,
        storageNetworks = storageNetworks,
    )
}
