@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.IpPoolsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The dnsServers of a device.
 * @property endingAddress Ending IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering.
 * @property startingAddress Starting IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering.
 */
public data class IpPoolsArgs(
    public val endingAddress: Output<String>? = null,
    public val startingAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.IpPoolsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.IpPoolsArgs =
        com.pulumi.azurenative.azurestackhci.inputs.IpPoolsArgs.builder()
            .endingAddress(endingAddress?.applyValue({ args0 -> args0 }))
            .startingAddress(startingAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpPoolsArgs].
 */
@PulumiTagMarker
public class IpPoolsArgsBuilder internal constructor() {
    private var endingAddress: Output<String>? = null

    private var startingAddress: Output<String>? = null

    /**
     * @param value Ending IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering.
     */
    @JvmName("ddouevllbglsixuk")
    public suspend fun endingAddress(`value`: Output<String>) {
        this.endingAddress = value
    }

    /**
     * @param value Starting IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering.
     */
    @JvmName("xcivlswdkqrfmlir")
    public suspend fun startingAddress(`value`: Output<String>) {
        this.startingAddress = value
    }

    /**
     * @param value Ending IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering.
     */
    @JvmName("obfbqrhfycydmbam")
    public suspend fun endingAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endingAddress = mapped
    }

    /**
     * @param value Starting IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering.
     */
    @JvmName("xjjglgxjbuuddpko")
    public suspend fun startingAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startingAddress = mapped
    }

    internal fun build(): IpPoolsArgs = IpPoolsArgs(
        endingAddress = endingAddress,
        startingAddress = startingAddress,
    )
}
