@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.SubnetPropertiesFormatIpConfigurationReferencesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IPConfigurationReference - Describes a IPConfiguration under the virtual network
 * @property id IPConfigurationID
 */
public data class SubnetPropertiesFormatIpConfigurationReferencesArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.SubnetPropertiesFormatIpConfigurationReferencesArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.SubnetPropertiesFormatIpConfigurationReferencesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.SubnetPropertiesFormatIpConfigurationReferencesArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetPropertiesFormatIpConfigurationReferencesArgs].
 */
@PulumiTagMarker
public class SubnetPropertiesFormatIpConfigurationReferencesArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value IPConfigurationID
     */
    @JvmName("xgfducsynrfnjsay")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value IPConfigurationID
     */
    @JvmName("mygpiwsybjbdudjb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SubnetPropertiesFormatIpConfigurationReferencesArgs =
        SubnetPropertiesFormatIpConfigurationReferencesArgs(
            id = id,
        )
}
