@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesLinuxConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * LinuxConfiguration - linux specific configuration values for the virtual machine instance
 * @property disablePasswordAuthentication DisablePasswordAuthentication - whether password authentication should be disabled
 * @property provisionVMAgent Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine instance creation process.
 * @property provisionVMConfigAgent Used to indicate whether the VM Config Agent should be installed during the virtual machine creation process.
 * @property ssh Specifies the ssh key configuration for a Linux OS.
 */
public data class VirtualMachineInstancePropertiesLinuxConfigurationArgs(
    public val disablePasswordAuthentication: Output<Boolean>? = null,
    public val provisionVMAgent: Output<Boolean>? = null,
    public val provisionVMConfigAgent: Output<Boolean>? = null,
    public val ssh: Output<SshConfigurationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesLinuxConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesLinuxConfigurationArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesLinuxConfigurationArgs.builder()
            .disablePasswordAuthentication(disablePasswordAuthentication?.applyValue({ args0 -> args0 }))
            .provisionVMAgent(provisionVMAgent?.applyValue({ args0 -> args0 }))
            .provisionVMConfigAgent(provisionVMConfigAgent?.applyValue({ args0 -> args0 }))
            .ssh(ssh?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualMachineInstancePropertiesLinuxConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstancePropertiesLinuxConfigurationArgsBuilder internal constructor() {
    private var disablePasswordAuthentication: Output<Boolean>? = null

    private var provisionVMAgent: Output<Boolean>? = null

    private var provisionVMConfigAgent: Output<Boolean>? = null

    private var ssh: Output<SshConfigurationArgs>? = null

    /**
     * @param value DisablePasswordAuthentication - whether password authentication should be disabled
     */
    @JvmName("tqtnsgntjoyymvtw")
    public suspend fun disablePasswordAuthentication(`value`: Output<Boolean>) {
        this.disablePasswordAuthentication = value
    }

    /**
     * @param value Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine instance creation process.
     */
    @JvmName("bppraqtxxnuaolyd")
    public suspend fun provisionVMAgent(`value`: Output<Boolean>) {
        this.provisionVMAgent = value
    }

    /**
     * @param value Used to indicate whether the VM Config Agent should be installed during the virtual machine creation process.
     */
    @JvmName("tduymsoekjofofid")
    public suspend fun provisionVMConfigAgent(`value`: Output<Boolean>) {
        this.provisionVMConfigAgent = value
    }

    /**
     * @param value Specifies the ssh key configuration for a Linux OS.
     */
    @JvmName("yftapslrmhluqurf")
    public suspend fun ssh(`value`: Output<SshConfigurationArgs>) {
        this.ssh = value
    }

    /**
     * @param value DisablePasswordAuthentication - whether password authentication should be disabled
     */
    @JvmName("ntrppxbxnmleberi")
    public suspend fun disablePasswordAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disablePasswordAuthentication = mapped
    }

    /**
     * @param value Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine instance creation process.
     */
    @JvmName("bcwlcchanidpqesi")
    public suspend fun provisionVMAgent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionVMAgent = mapped
    }

    /**
     * @param value Used to indicate whether the VM Config Agent should be installed during the virtual machine creation process.
     */
    @JvmName("yfulrptsrjkyehld")
    public suspend fun provisionVMConfigAgent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionVMConfigAgent = mapped
    }

    /**
     * @param value Specifies the ssh key configuration for a Linux OS.
     */
    @JvmName("aijxennvodlcucus")
    public suspend fun ssh(`value`: SshConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssh = mapped
    }

    /**
     * @param argument Specifies the ssh key configuration for a Linux OS.
     */
    @JvmName("vosbaktixoeatplq")
    public suspend fun ssh(argument: suspend SshConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = SshConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ssh = mapped
    }

    internal fun build(): VirtualMachineInstancePropertiesLinuxConfigurationArgs =
        VirtualMachineInstancePropertiesLinuxConfigurationArgs(
            disablePasswordAuthentication = disablePasswordAuthentication,
            provisionVMAgent = provisionVMAgent,
            provisionVMConfigAgent = provisionVMConfigAgent,
            ssh = ssh,
        )
}
