@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesStorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * StorageProfile - contains information about the disks and storage information for the virtual machine instance
 * @property dataDisks adds data disks to the virtual machine instance
 * @property imageReference Which Image to use for the virtual machine instance
 * @property osDisk VHD to attach as OS disk
 * @property vmConfigStoragePathId Id of the storage container that hosts the VM configuration file
 */
public data class VirtualMachineInstancePropertiesStorageProfileArgs(
    public val dataDisks: Output<List<VirtualMachineInstancePropertiesDataDisksArgs>>? = null,
    public val imageReference: Output<VirtualMachineInstancePropertiesImageReferenceArgs>? = null,
    public val osDisk: Output<VirtualMachineInstancePropertiesOsDiskArgs>? = null,
    public val vmConfigStoragePathId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesStorageProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesStorageProfileArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesStorageProfileArgs.builder()
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .imageReference(imageReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osDisk(osDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmConfigStoragePathId(vmConfigStoragePathId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineInstancePropertiesStorageProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstancePropertiesStorageProfileArgsBuilder internal constructor() {
    private var dataDisks: Output<List<VirtualMachineInstancePropertiesDataDisksArgs>>? = null

    private var imageReference: Output<VirtualMachineInstancePropertiesImageReferenceArgs>? = null

    private var osDisk: Output<VirtualMachineInstancePropertiesOsDiskArgs>? = null

    private var vmConfigStoragePathId: Output<String>? = null

    /**
     * @param value adds data disks to the virtual machine instance
     */
    @JvmName("cfbjhehqefvjlwsb")
    public suspend
    fun dataDisks(`value`: Output<List<VirtualMachineInstancePropertiesDataDisksArgs>>) {
        this.dataDisks = value
    }

    @JvmName("evoqjnpvanaprlbc")
    public suspend fun dataDisks(
        vararg
        values: Output<VirtualMachineInstancePropertiesDataDisksArgs>,
    ) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values adds data disks to the virtual machine instance
     */
    @JvmName("mgihkaxkmxefnybw")
    public suspend
    fun dataDisks(values: List<Output<VirtualMachineInstancePropertiesDataDisksArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value Which Image to use for the virtual machine instance
     */
    @JvmName("ljapbxuftrrgxcfq")
    public suspend
    fun imageReference(`value`: Output<VirtualMachineInstancePropertiesImageReferenceArgs>) {
        this.imageReference = value
    }

    /**
     * @param value VHD to attach as OS disk
     */
    @JvmName("ujlsaywyembdgdee")
    public suspend fun osDisk(`value`: Output<VirtualMachineInstancePropertiesOsDiskArgs>) {
        this.osDisk = value
    }

    /**
     * @param value Id of the storage container that hosts the VM configuration file
     */
    @JvmName("cvjbfijfuliftlee")
    public suspend fun vmConfigStoragePathId(`value`: Output<String>) {
        this.vmConfigStoragePathId = value
    }

    /**
     * @param value adds data disks to the virtual machine instance
     */
    @JvmName("cvqjltcktgyqviba")
    public suspend fun dataDisks(`value`: List<VirtualMachineInstancePropertiesDataDisksArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument adds data disks to the virtual machine instance
     */
    @JvmName("dpaobpbvmmtoweqp")
    public suspend
    fun dataDisks(argument: List<suspend VirtualMachineInstancePropertiesDataDisksArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineInstancePropertiesDataDisksArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument adds data disks to the virtual machine instance
     */
    @JvmName("avhjoiktyvmfdoek")
    public suspend fun dataDisks(
        vararg
        argument: suspend VirtualMachineInstancePropertiesDataDisksArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachineInstancePropertiesDataDisksArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument adds data disks to the virtual machine instance
     */
    @JvmName("tcmdwxtoalnwwlln")
    public suspend
    fun dataDisks(argument: suspend VirtualMachineInstancePropertiesDataDisksArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachineInstancePropertiesDataDisksArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values adds data disks to the virtual machine instance
     */
    @JvmName("kgbtbwqietamocml")
    public suspend fun dataDisks(vararg values: VirtualMachineInstancePropertiesDataDisksArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value Which Image to use for the virtual machine instance
     */
    @JvmName("dklqouitbwcsqnux")
    public suspend fun imageReference(`value`: VirtualMachineInstancePropertiesImageReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageReference = mapped
    }

    /**
     * @param argument Which Image to use for the virtual machine instance
     */
    @JvmName("iulbuubrmhvaykmk")
    public suspend
    fun imageReference(argument: suspend VirtualMachineInstancePropertiesImageReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineInstancePropertiesImageReferenceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.imageReference = mapped
    }

    /**
     * @param value VHD to attach as OS disk
     */
    @JvmName("wttvlfvamypiyfxh")
    public suspend fun osDisk(`value`: VirtualMachineInstancePropertiesOsDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDisk = mapped
    }

    /**
     * @param argument VHD to attach as OS disk
     */
    @JvmName("fcfvtiwnjitpqwff")
    public suspend
    fun osDisk(argument: suspend VirtualMachineInstancePropertiesOsDiskArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineInstancePropertiesOsDiskArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.osDisk = mapped
    }

    /**
     * @param value Id of the storage container that hosts the VM configuration file
     */
    @JvmName("hgdhjfpeageyqlpg")
    public suspend fun vmConfigStoragePathId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmConfigStoragePathId = mapped
    }

    internal fun build(): VirtualMachineInstancePropertiesStorageProfileArgs =
        VirtualMachineInstancePropertiesStorageProfileArgs(
            dataDisks = dataDisks,
            imageReference = imageReference,
            osDisk = osDisk,
            vmConfigStoragePathId = vmConfigStoragePathId,
        )
}
