@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesDataDisksArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id Resource ID of the data disk
 */
public data class VirtualMachinePropertiesDataDisksArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesDataDisksArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesDataDisksArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesDataDisksArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachinePropertiesDataDisksArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesDataDisksArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID of the data disk
     */
    @JvmName("orlewunytdgxanfb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID of the data disk
     */
    @JvmName("fjlxwntxohpypvio")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): VirtualMachinePropertiesDataDisksArgs =
        VirtualMachinePropertiesDataDisksArgs(
            id = id,
        )
}
