@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesDhcpOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
 * @property dnsServers The list of DNS servers IP addresses.
 */
public data class VirtualNetworkPropertiesDhcpOptionsArgs(
    public val dnsServers: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesDhcpOptionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesDhcpOptionsArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesDhcpOptionsArgs.builder()
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VirtualNetworkPropertiesDhcpOptionsArgs].
 */
@PulumiTagMarker
public class VirtualNetworkPropertiesDhcpOptionsArgsBuilder internal constructor() {
    private var dnsServers: Output<List<String>>? = null

    /**
     * @param value The list of DNS servers IP addresses.
     */
    @JvmName("jfykfypmxulinhpd")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("wqfygsiiobhrecnm")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values The list of DNS servers IP addresses.
     */
    @JvmName("rvgntsvqidrfhqml")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value The list of DNS servers IP addresses.
     */
    @JvmName("gmwihyceynuuiyqi")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values The list of DNS servers IP addresses.
     */
    @JvmName("fpdanualyowwoewn")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    internal fun build(): VirtualNetworkPropertiesDhcpOptionsArgs =
        VirtualNetworkPropertiesDhcpOptionsArgs(
            dnsServers = dnsServers,
        )
}
