@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesRoutesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Route is associated with a subnet.
 * @property addressPrefix AddressPrefix - The destination CIDR to which the route applies.
 * @property name Name - name of the subnet
 * @property nextHopIpAddress NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
 */
public data class VirtualNetworkPropertiesRoutesArgs(
    public val addressPrefix: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nextHopIpAddress: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesRoutesArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesRoutesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesRoutesArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nextHopIpAddress(nextHopIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkPropertiesRoutesArgs].
 */
@PulumiTagMarker
public class VirtualNetworkPropertiesRoutesArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var name: Output<String>? = null

    private var nextHopIpAddress: Output<String>? = null

    /**
     * @param value AddressPrefix - The destination CIDR to which the route applies.
     */
    @JvmName("sukxvylvrsbmwmal")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value Name - name of the subnet
     */
    @JvmName("rcvixlgdnowbgnxt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
     */
    @JvmName("ysfwlmljwysyibit")
    public suspend fun nextHopIpAddress(`value`: Output<String>) {
        this.nextHopIpAddress = value
    }

    /**
     * @param value AddressPrefix - The destination CIDR to which the route applies.
     */
    @JvmName("mrpptfmmohlhdmvr")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value Name - name of the subnet
     */
    @JvmName("lrvxqxdjtaiciclv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
     */
    @JvmName("ksjlkraorcixjpih")
    public suspend fun nextHopIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextHopIpAddress = mapped
    }

    internal fun build(): VirtualNetworkPropertiesRoutesArgs = VirtualNetworkPropertiesRoutesArgs(
        addressPrefix = addressPrefix,
        name = name,
        nextHopIpAddress = nextHopIpAddress,
    )
}
