@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The AdapterPropertyOverrides of a cluster.
 * @property jumboPacket This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property networkDirect This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property networkDirectTechnology This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. Expected values are 'iWARP', 'RoCEv2', 'RoCE'
 */
public data class AdapterPropertyOverridesResponse(
    public val jumboPacket: String? = null,
    public val networkDirect: String? = null,
    public val networkDirectTechnology: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.AdapterPropertyOverridesResponse):
            AdapterPropertyOverridesResponse = AdapterPropertyOverridesResponse(
            jumboPacket = javaType.jumboPacket().map({ args0 -> args0 }).orElse(null),
            networkDirect = javaType.networkDirect().map({ args0 -> args0 }).orElse(null),
            networkDirectTechnology = javaType.networkDirectTechnology().map({ args0 -> args0 }).orElse(null),
        )
    }
}
