@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * AzureStackHCI Cluster deployment properties.
 * @property azureServiceEndpoint For Azure blob service endpoint type, select either Default or Custom domain. If you selected **Custom domain, enter the domain for the blob service in this format core.windows.net.
 * @property cloudAccountName Specify the Azure Storage account name for cloud witness for your Azure Stack HCI cluster.
 * @property name The cluster name provided when preparing Active Directory.
 * @property witnessPath Specify the fileshare path for the local witness for your Azure Stack HCI cluster.
 * @property witnessType Use a cloud witness if you have internet access and if you use an Azure Storage account to provide a vote on cluster quorum. A cloud witness uses Azure Blob Storage to read or write a blob file and then uses it to arbitrate in split-brain resolution. Only allowed values are 'Cloud', 'FileShare'.
 */
public data class ClusterResponse(
    public val azureServiceEndpoint: String? = null,
    public val cloudAccountName: String? = null,
    public val name: String? = null,
    public val witnessPath: String? = null,
    public val witnessType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.ClusterResponse):
            ClusterResponse = ClusterResponse(
            azureServiceEndpoint = javaType.azureServiceEndpoint().map({ args0 -> args0 }).orElse(null),
            cloudAccountName = javaType.cloudAccountName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            witnessPath = javaType.witnessPath().map({ args0 -> args0 }).orElse(null),
            witnessType = javaType.witnessType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
