@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties for a particular default extension category.
 * @property category Default extension category
 * @property consentTime Consent time for extension category
 */
public data class DefaultExtensionDetailsResponse(
    public val category: String,
    public val consentTime: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.DefaultExtensionDetailsResponse):
            DefaultExtensionDetailsResponse = DefaultExtensionDetailsResponse(
            category = javaType.category(),
            consentTime = javaType.consentTime(),
        )
    }
}
