@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * This is the gallery image definition identifier.
 * @property offer The name of the gallery image definition offer.
 * @property publisher The name of the gallery image definition publisher.
 * @property sku The name of the gallery image definition SKU.
 */
public data class GalleryImageIdentifierResponse(
    public val offer: String,
    public val publisher: String,
    public val sku: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GalleryImageIdentifierResponse):
            GalleryImageIdentifierResponse = GalleryImageIdentifierResponse(
            offer = javaType.offer(),
            publisher = javaType.publisher(),
            sku = javaType.sku(),
        )
    }
}
