@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies information about the gallery image version that you want to create or update.
 * @property name This is the version of the gallery image.
 * @property storageProfile This is the storage profile of a Gallery Image Version.
 */
public data class GalleryImageVersionResponse(
    public val name: String? = null,
    public val storageProfile: GalleryImageVersionStorageProfileResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GalleryImageVersionResponse):
            GalleryImageVersionResponse = GalleryImageVersionResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            storageProfile = javaType.storageProfile().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.GalleryImageVersionStorageProfileResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
