@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * ArcSetting details.
 * @property aggregateState Aggregate state of Arc agent across the nodes in this HCI cluster.
 * @property arcApplicationClientId App id of arc AAD identity.
 * @property arcApplicationObjectId Object id of arc AAD identity.
 * @property arcApplicationTenantId Tenant id of arc AAD identity.
 * @property arcInstanceResourceGroup The resource group that hosts the Arc agents, ie. Hybrid Compute Machine resources.
 * @property arcServicePrincipalObjectId Object id of arc AAD service principal.
 * @property connectivityProperties contains connectivity related configuration for ARC resources
 * @property defaultExtensions Properties for each of the default extensions category
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property perNodeDetails State of Arc agent in each of the nodes.
 * @property provisioningState Provisioning state of the ArcSetting proxy resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetArcSettingResult(
    public val aggregateState: String,
    public val arcApplicationClientId: String? = null,
    public val arcApplicationObjectId: String? = null,
    public val arcApplicationTenantId: String? = null,
    public val arcInstanceResourceGroup: String? = null,
    public val arcServicePrincipalObjectId: String? = null,
    public val connectivityProperties: List<ArcConnectivityPropertiesResponse>? = null,
    public val defaultExtensions: List<DefaultExtensionDetailsResponse>,
    public val id: String,
    public val name: String,
    public val perNodeDetails: List<PerNodeStateResponse>,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetArcSettingResult):
            GetArcSettingResult = GetArcSettingResult(
            aggregateState = javaType.aggregateState(),
            arcApplicationClientId = javaType.arcApplicationClientId().map({ args0 -> args0 }).orElse(null),
            arcApplicationObjectId = javaType.arcApplicationObjectId().map({ args0 -> args0 }).orElse(null),
            arcApplicationTenantId = javaType.arcApplicationTenantId().map({ args0 -> args0 }).orElse(null),
            arcInstanceResourceGroup = javaType.arcInstanceResourceGroup().map({ args0 -> args0 }).orElse(null),
            arcServicePrincipalObjectId = javaType.arcServicePrincipalObjectId().map({ args0 ->
                args0
            }).orElse(null),
            connectivityProperties = javaType.connectivityProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ArcConnectivityPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            defaultExtensions = javaType.defaultExtensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.DefaultExtensionDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            perNodeDetails = javaType.perNodeDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.PerNodeStateResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
