@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Edge device resource
 * @property arcNodeResourceIds Azure resource ids of Arc machines to be part of cluster.
 * @property deploymentConfiguration Scale units will contains list of deployment data
 * @property deploymentMode The deployment mode for cluster deployment.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState DeploymentSetting provisioning state
 * @property reportedProperties Deployment Status reported from cluster.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDeploymentSettingResult(
    public val arcNodeResourceIds: List<String>,
    public val deploymentConfiguration: DeploymentConfigurationResponse,
    public val deploymentMode: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val reportedProperties: ReportedPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetDeploymentSettingResult):
            GetDeploymentSettingResult = GetDeploymentSettingResult(
            arcNodeResourceIds = javaType.arcNodeResourceIds().map({ args0 -> args0 }),
            deploymentConfiguration = javaType.deploymentConfiguration().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.DeploymentConfigurationResponse.Companion.toKotlin(args0)
            }),
            deploymentMode = javaType.deploymentMode(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            reportedProperties = javaType.reportedProperties().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.ReportedPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
