@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The marketplace gallery image resource definition.
 * @property cloudInitDataSource Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
 * @property containerName Container Name for storage container
 * @property extendedLocation The extendedLocation of the resource.
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine [V1, V2]
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identifier This is the gallery image definition identifier.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property osType Operating system type that the gallery image uses [Windows, Linux]
 * @property provisioningState Provisioning state of the marketplace gallery image.
 * @property status The observed state of marketplace gallery images
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version Specifies information about the gallery image version that you want to create or update.
 */
public data class GetMarketplaceGalleryImageResult(
    public val cloudInitDataSource: String? = null,
    public val containerName: String? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val hyperVGeneration: String? = null,
    public val id: String,
    public val identifier: GalleryImageIdentifierResponse? = null,
    public val location: String,
    public val name: String,
    public val osType: String? = null,
    public val provisioningState: String,
    public val status: MarketplaceGalleryImageStatusResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val version: GalleryImageVersionResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetMarketplaceGalleryImageResult):
            GetMarketplaceGalleryImageResult = GetMarketplaceGalleryImageResult(
            cloudInitDataSource = javaType.cloudInitDataSource().map({ args0 -> args0 }).orElse(null),
            containerName = javaType.containerName().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hyperVGeneration = javaType.hyperVGeneration().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identifier = javaType.identifier().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.GalleryImageIdentifierResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.MarketplaceGalleryImageStatusResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            version = javaType.version().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.GalleryImageVersionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
