@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Details of an Update run
 * @property description More detailed description of the step.
 * @property duration Duration of the update run.
 * @property endTimeUtc When the step reached a terminal state.
 * @property errorMessage Error message, specified if the step is in a failed state.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastUpdatedTime Timestamp of the most recently completed step in the update run.
 * @property lastUpdatedTimeUtc Completion time of this step or the last completed sub-step.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the UpdateRuns proxy resource.
 * @property startTimeUtc When the step started, or empty if it has not started executing.
 * @property state State of the update run.
 * @property status Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'.
 * @property steps Recursive model for child steps of this step.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property timeStarted Timestamp of the update run was started.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetUpdateRunResult(
    public val description: String? = null,
    public val duration: String? = null,
    public val endTimeUtc: String? = null,
    public val errorMessage: String? = null,
    public val id: String,
    public val lastUpdatedTime: String? = null,
    public val lastUpdatedTimeUtc: String? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val startTimeUtc: String? = null,
    public val state: String? = null,
    public val status: String? = null,
    public val steps: List<StepResponse>? = null,
    public val systemData: SystemDataResponse,
    public val timeStarted: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetUpdateRunResult):
            GetUpdateRunResult = GetUpdateRunResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
            endTimeUtc = javaType.endTimeUtc().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastUpdatedTime = javaType.lastUpdatedTime().map({ args0 -> args0 }).orElse(null),
            lastUpdatedTimeUtc = javaType.lastUpdatedTimeUtc().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            startTimeUtc = javaType.startTimeUtc().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            steps = javaType.steps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.StepResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            timeStarted = javaType.timeStarted().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
