@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The observed state of marketplace gallery images
 * @property downloadStatus The download status of the gallery image
 * @property errorCode MarketplaceGalleryImage provisioning error code
 * @property errorMessage Descriptive error message
 * @property progressPercentage The progress of the operation in percentage
 * @property provisioningStatus
 */
public data class MarketplaceGalleryImageStatusResponse(
    public val downloadStatus: MarketplaceGalleryImageStatusResponseDownloadStatus? = null,
    public val errorCode: String? = null,
    public val errorMessage: String? = null,
    public val progressPercentage: Double? = null,
    public val provisioningStatus: MarketplaceGalleryImageStatusResponseProvisioningStatus? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.MarketplaceGalleryImageStatusResponse):
            MarketplaceGalleryImageStatusResponse = MarketplaceGalleryImageStatusResponse(
            downloadStatus = javaType.downloadStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.MarketplaceGalleryImageStatusResponseDownloadStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
            errorCode = javaType.errorCode().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            progressPercentage = javaType.progressPercentage().map({ args0 -> args0 }).orElse(null),
            provisioningStatus = javaType.provisioningStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.MarketplaceGalleryImageStatusResponseProvisioningStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
